@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peConnectionName Private link resource name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val peConnectionName: String,
    public val resourceGroupName: String,
    public val siteName: String,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.offazure.inputs.GetPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.offazure.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
            .peConnectionName(peConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteName(siteName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var peConnectionName: String? = null

    private var resourceGroupName: String? = null

    private var siteName: String? = null

    /**
     * @param value Private link resource name.
     */
    @JvmName("nrfffgivetovajyk")
    public suspend fun peConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peConnectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("icbtpdqivxmslmip")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name.
     */
    @JvmName("gfqeqndocfyticnv")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            peConnectionName = peConnectionName ?: throw PulumiNullFieldException("peConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            siteName = siteName ?: throw PulumiNullFieldException("siteName"),
        )
}
