@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.GetWebAppDiscoverySiteDataSourcesControllerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property discoverySiteDataSourceName Data Source ARM name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name
 * @property webAppSiteName Web app site name.
 */
public data class GetWebAppDiscoverySiteDataSourcesControllerPlainArgs(
    public val discoverySiteDataSourceName: String,
    public val resourceGroupName: String,
    public val siteName: String,
    public val webAppSiteName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.GetWebAppDiscoverySiteDataSourcesControllerPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.offazure.inputs.GetWebAppDiscoverySiteDataSourcesControllerPlainArgs =
        com.pulumi.azurenative.offazure.inputs.GetWebAppDiscoverySiteDataSourcesControllerPlainArgs.builder()
            .discoverySiteDataSourceName(discoverySiteDataSourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteName(siteName.let({ args0 -> args0 }))
            .webAppSiteName(webAppSiteName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppDiscoverySiteDataSourcesControllerPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppDiscoverySiteDataSourcesControllerPlainArgsBuilder internal constructor() {
    private var discoverySiteDataSourceName: String? = null

    private var resourceGroupName: String? = null

    private var siteName: String? = null

    private var webAppSiteName: String? = null

    /**
     * @param value Data Source ARM name.
     */
    @JvmName("bnkelehmhjbtqnnh")
    public suspend fun discoverySiteDataSourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.discoverySiteDataSourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ombveojmpnjhkemf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("xaxjhtcrcyjkidkh")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    /**
     * @param value Web app site name.
     */
    @JvmName("qexhtmdsbtjfkcok")
    public suspend fun webAppSiteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.webAppSiteName = mapped
    }

    internal fun build(): GetWebAppDiscoverySiteDataSourcesControllerPlainArgs =
        GetWebAppDiscoverySiteDataSourcesControllerPlainArgs(
            discoverySiteDataSourceName = discoverySiteDataSourceName ?: throw
                PulumiNullFieldException("discoverySiteDataSourceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            siteName = siteName ?: throw PulumiNullFieldException("siteName"),
            webAppSiteName = webAppSiteName ?: throw PulumiNullFieldException("webAppSiteName"),
        )
}
