@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.SiteAgentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class for site agent properties.
 * @property keyVaultId Gets or sets the key vault ARM Id.
 * @property keyVaultUri Gets or sets the key vault URI.
 */
public data class SiteAgentPropertiesArgs(
    public val keyVaultId: Output<String>? = null,
    public val keyVaultUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.SiteAgentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.inputs.SiteAgentPropertiesArgs =
        com.pulumi.azurenative.offazure.inputs.SiteAgentPropertiesArgs.builder()
            .keyVaultId(keyVaultId?.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SiteAgentPropertiesArgs].
 */
@PulumiTagMarker
public class SiteAgentPropertiesArgsBuilder internal constructor() {
    private var keyVaultId: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    /**
     * @param value Gets or sets the key vault ARM Id.
     */
    @JvmName("rwmgeblvkcwyhrvv")
    public suspend fun keyVaultId(`value`: Output<String>) {
        this.keyVaultId = value
    }

    /**
     * @param value Gets or sets the key vault URI.
     */
    @JvmName("qkmodcevnjsmrcko")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value Gets or sets the key vault ARM Id.
     */
    @JvmName("auaiurarvgergxdd")
    public suspend fun keyVaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultId = mapped
    }

    /**
     * @param value Gets or sets the key vault URI.
     */
    @JvmName("yrbixpsjwyggpuai")
    public suspend fun keyVaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    internal fun build(): SiteAgentPropertiesArgs = SiteAgentPropertiesArgs(
        keyVaultId = keyVaultId,
        keyVaultUri = keyVaultUri,
    )
}
