@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A host resource belonging to a site resource.
 * @property createdTimestamp Gets the timestamp marking Hyper-V host creation.
 * @property errors Gets the errors.
 * @property fqdn Gets or sets the FQDN/IPAddress of the Hyper-V host.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property runAsAccountId Gets or sets the run as account ID of the Hyper-V host.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatedTimestamp Gets the timestamp marking last updated on the Hyper-V host.
 * @property version Gets the version of the Hyper-V host.
 */
public data class GetHypervHostControllerResult(
    public val createdTimestamp: String,
    public val errors: List<HealthErrorDetailsResponse>,
    public val fqdn: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String? = null,
    public val runAsAccountId: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatedTimestamp: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.GetHypervHostControllerResult):
            GetHypervHostControllerResult = GetHypervHostControllerResult(
            createdTimestamp = javaType.createdTimestamp(),
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.HealthErrorDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            runAsAccountId = javaType.runAsAccountId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatedTimestamp = javaType.updatedTimestamp(),
            version = javaType.version(),
        )
    }
}
