@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class for site agent properties.
 * @property id Gets the ID of the agent.
 * @property keyVaultId Gets or sets the key vault ARM Id.
 * @property keyVaultUri Gets or sets the key vault URI.
 * @property lastHeartBeatUtc Gets the last heartbeat time of the agent in UTC.
 * @property version Gets the version of the agent.
 */
public data class SiteAgentPropertiesResponse(
    public val id: String,
    public val keyVaultId: String? = null,
    public val keyVaultUri: String? = null,
    public val lastHeartBeatUtc: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.SiteAgentPropertiesResponse):
            SiteAgentPropertiesResponse = SiteAgentPropertiesResponse(
            id = javaType.id(),
            keyVaultId = javaType.keyVaultId().map({ args0 -> args0 }).orElse(null),
            keyVaultUri = javaType.keyVaultUri().map({ args0 -> args0 }).orElse(null),
            lastHeartBeatUtc = javaType.lastHeartBeatUtc(),
            version = javaType.version(),
        )
    }
}
