@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The springbootsites resource definition.
 * @property masterSiteId The master site ID from Azure Migrate.
 * @property migrateProjectId The migrate project ID from Azure Migrate.
 * @property provisioningState The resource provisioning state.
 */
public data class SpringbootsitesPropertiesResponse(
    public val masterSiteId: String? = null,
    public val migrateProjectId: String? = null,
    public val provisioningState: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.offazurespringboot.outputs.SpringbootsitesPropertiesResponse):
            SpringbootsitesPropertiesResponse = SpringbootsitesPropertiesResponse(
            masterSiteId = javaType.masterSiteId().map({ args0 -> args0 }).orElse(null),
            migrateProjectId = javaType.migrateProjectId().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
