@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.DataSourceArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.enums.DataSourceKind
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Datasources under OMS Workspace.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * Other available API versions: 2015-11-01-preview.
 * ## Example Usage
 * ### DataSourcesCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataSource = new AzureNative.OperationalInsights.DataSource("dataSource", new()
 *     {
 *         DataSourceName = "AzTestDS774",
 *         Kind = "AzureActivityLog",
 *         Properties =
 *         {
 *             { "LinkedResourceId", "/subscriptions/00000000-0000-0000-0000-00000000000/providers/microsoft.insights/eventtypes/management" },
 *         },
 *         ResourceGroupName = "OIAutoRest5123",
 *         WorkspaceName = "AzTest9724",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewDataSource(ctx, "dataSource", &operationalinsights.DataSourceArgs{
 * 			DataSourceName: pulumi.String("AzTestDS774"),
 * 			Kind:           pulumi.String("AzureActivityLog"),
 * 			Properties: pulumi.Any{
 * 				LinkedResourceId: "/subscriptions/00000000-0000-0000-0000-00000000000/providers/microsoft.insights/eventtypes/management",
 * 			},
 * 			ResourceGroupName: pulumi.String("OIAutoRest5123"),
 * 			WorkspaceName:     pulumi.String("AzTest9724"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.DataSource;
 * import com.pulumi.azurenative.operationalinsights.DataSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataSource = new DataSource("dataSource", DataSourceArgs.builder()
 *             .dataSourceName("AzTestDS774")
 *             .kind("AzureActivityLog")
 *             .properties(Map.of("LinkedResourceId", "/subscriptions/00000000-0000-0000-0000-00000000000/providers/microsoft.insights/eventtypes/management"))
 *             .resourceGroupName("OIAutoRest5123")
 *             .workspaceName("AzTest9724")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:DataSource AzTestDS774 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources/{dataSourceName}
 * ```
 * @property dataSourceName The name of the datasource resource.
 * @property kind The kind of the DataSource.
 * @property properties The data source properties in raw json format, each kind of data source have it's own schema.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property workspaceName The name of the workspace.
 */
public data class DataSourceArgs(
    public val dataSourceName: Output<String>? = null,
    public val kind: Output<Either<String, DataSourceKind>>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.DataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.DataSourceArgs =
        com.pulumi.azurenative.operationalinsights.DataSourceArgs.builder()
            .dataSourceName(dataSourceName?.applyValue({ args0 -> args0 }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceArgs].
 */
@PulumiTagMarker
public class DataSourceArgsBuilder internal constructor() {
    private var dataSourceName: Output<String>? = null

    private var kind: Output<Either<String, DataSourceKind>>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the datasource resource.
     */
    @JvmName("tkbbshxfnfcmwwvk")
    public suspend fun dataSourceName(`value`: Output<String>) {
        this.dataSourceName = value
    }

    /**
     * @param value The kind of the DataSource.
     */
    @JvmName("mbifvsvdogxmitcc")
    public suspend fun kind(`value`: Output<Either<String, DataSourceKind>>) {
        this.kind = value
    }

    /**
     * @param value The data source properties in raw json format, each kind of data source have it's own schema.
     */
    @JvmName("pyvmwgkvxgtibdln")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hwsbxlehhkivtmbi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rcwyfhjupovhblur")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("pgqtbettiduolxel")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the datasource resource.
     */
    @JvmName("pfcijekwrckuxmnu")
    public suspend fun dataSourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceName = mapped
    }

    /**
     * @param value The kind of the DataSource.
     */
    @JvmName("acpgasgkmcqjnqii")
    public suspend fun kind(`value`: Either<String, DataSourceKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the DataSource.
     */
    @JvmName("mvttwchyhscwpyaf")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataSourceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the DataSource.
     */
    @JvmName("okhnmnjkxodkfpxb")
    public fun kind(`value`: DataSourceKind) {
        val toBeMapped = Either.ofRight<String, DataSourceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The data source properties in raw json format, each kind of data source have it's own schema.
     */
    @JvmName("pafnjdvuminvexdj")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jgwbgwxvfsjawvaj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vxmrmyhvmvbypoft")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dxosjcapnxmpcfqw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("gesvalneyvbaeddo")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): DataSourceArgs = DataSourceArgs(
        dataSourceName = dataSourceName,
        kind = kind,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workspaceName = workspaceName,
    )
}
