@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.kotlin.outputs.RestoredLogsResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.ResultStatisticsResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.SchemaResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.SearchResultsResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.RestoredLogsResponse.Companion.toKotlin as restoredLogsResponseToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.ResultStatisticsResponse.Companion.toKotlin as resultStatisticsResponseToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.SchemaResponse.Companion.toKotlin as schemaResponseToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.SearchResultsResponse.Companion.toKotlin as searchResultsResponseToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Table].
 */
@PulumiTagMarker
public class TableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TableArgs = TableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TableArgsBuilder.() -> Unit) {
        val builder = TableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Table {
        val builtJavaResource =
            com.pulumi.azurenative.operationalinsights.Table(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Table(builtJavaResource)
    }
}

/**
 * Workspace data table definition.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * ## Example Usage
 * ### TablesUpsert
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var table = new AzureNative.OperationalInsights.Table("table", new()
 *     {
 *         ResourceGroupName = "oiautorest6685",
 *         RetentionInDays = 45,
 *         Schema = new AzureNative.OperationalInsights.Inputs.SchemaArgs
 *         {
 *             Columns = new[]
 *             {
 *                 new AzureNative.OperationalInsights.Inputs.ColumnArgs
 *                 {
 *                     Name = "MyNewColumn",
 *                     Type = "guid",
 *                 },
 *             },
 *             Name = "AzureNetworkFlow",
 *         },
 *         TableName = "AzureNetworkFlow",
 *         TotalRetentionInDays = 70,
 *         WorkspaceName = "oiautorest6685",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewTable(ctx, "table", &operationalinsights.TableArgs{
 * 			ResourceGroupName: pulumi.String("oiautorest6685"),
 * 			RetentionInDays:   pulumi.Int(45),
 * 			Schema: operationalinsights.SchemaResponse{
 * 				Columns: operationalinsights.ColumnArray{
 * 					&operationalinsights.ColumnArgs{
 * 						Name: pulumi.String("MyNewColumn"),
 * 						Type: pulumi.String("guid"),
 * 					},
 * 				},
 * 				Name: pulumi.String("AzureNetworkFlow"),
 * 			},
 * 			TableName:            pulumi.String("AzureNetworkFlow"),
 * 			TotalRetentionInDays: pulumi.Int(70),
 * 			WorkspaceName:        pulumi.String("oiautorest6685"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.Table;
 * import com.pulumi.azurenative.operationalinsights.TableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var table = new Table("table", TableArgs.builder()
 *             .resourceGroupName("oiautorest6685")
 *             .retentionInDays(45)
 *             .schema(Map.ofEntries(
 *                 Map.entry("columns", Map.ofEntries(
 *                     Map.entry("name", "MyNewColumn"),
 *                     Map.entry("type", "guid")
 *                 )),
 *                 Map.entry("name", "AzureNetworkFlow")
 *             ))
 *             .tableName("AzureNetworkFlow")
 *             .totalRetentionInDays(70)
 *             .workspaceName("oiautorest6685")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:Table AzureNetworkFlow /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/tables/{tableName}
 * ```
 */
public class Table internal constructor(
    override val javaResource: com.pulumi.azurenative.operationalinsights.Table,
) : KotlinCustomResource(javaResource, TableMapper) {
    /**
     * The table data archive retention in days. Calculated as (totalRetentionInDays-retentionInDays)
     */
    public val archiveRetentionInDays: Output<Int>
        get() = javaResource.archiveRetentionInDays().applyValue({ args0 -> args0 })

    /**
     * The timestamp that table plan was last modified (UTC).
     */
    public val lastPlanModifiedDate: Output<String>
        get() = javaResource.lastPlanModifiedDate().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Instruct the system how to handle and charge the logs ingested to this table.
     */
    public val plan: Output<String>?
        get() = javaResource.plan().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Table's current provisioning state. If set to 'updating', indicates a resource lock due to ongoing operation, forbidding any update to the table until the ongoing operation is concluded.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Parameters of the restore operation that initiated this table.
     */
    public val restoredLogs: Output<RestoredLogsResponse>?
        get() = javaResource.restoredLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    restoredLogsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Search job execution statistics.
     */
    public val resultStatistics: Output<ResultStatisticsResponse>
        get() = javaResource.resultStatistics().applyValue({ args0 ->
            args0.let({ args0 ->
                resultStatisticsResponseToKotlin(args0)
            })
        })

    /**
     * The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention.
     */
    public val retentionInDays: Output<Int>?
        get() = javaResource.retentionInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * True - Value originates from workspace retention in days, False - Customer specific.
     */
    public val retentionInDaysAsDefault: Output<Boolean>
        get() = javaResource.retentionInDaysAsDefault().applyValue({ args0 -> args0 })

    /**
     * Table schema.
     */
    public val schema: Output<SchemaResponse>?
        get() = javaResource.schema().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    schemaResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Parameters of the search job that initiated this table.
     */
    public val searchResults: Output<SearchResultsResponse>?
        get() = javaResource.searchResults().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> searchResultsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The table total retention in days, between 4 and 2556. Setting this property to -1 will default to table retention.
     */
    public val totalRetentionInDays: Output<Int>?
        get() = javaResource.totalRetentionInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * True - Value originates from retention in days, False - Customer specific.
     */
    public val totalRetentionInDaysAsDefault: Output<Boolean>
        get() = javaResource.totalRetentionInDaysAsDefault().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TableMapper : ResourceMapper<Table> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationalinsights.Table::class == javaResource::class

    override fun map(javaResource: Resource): Table = Table(
        javaResource as
            com.pulumi.azurenative.operationalinsights.Table,
    )
}

/**
 * @see [Table].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Table].
 */
public suspend fun table(name: String, block: suspend TableResourceBuilder.() -> Unit): Table {
    val builder = TableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Table].
 * @param name The _unique_ name of the resulting resource.
 */
public fun table(name: String): Table {
    val builder = TableResourceBuilder()
    builder.name(name)
    return builder.build()
}
