@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.PrivateLinkScopedResourceResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.WorkspaceCappingResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.WorkspaceFeaturesResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.WorkspaceSkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.PrivateLinkScopedResourceResponse.Companion.toKotlin as privateLinkScopedResourceResponseToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.WorkspaceCappingResponse.Companion.toKotlin as workspaceCappingResponseToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.WorkspaceFeaturesResponse.Companion.toKotlin as workspaceFeaturesResponseToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.WorkspaceSkuResponse.Companion.toKotlin as workspaceSkuResponseToKotlin

/**
 * Builder for [Workspace].
 */
@PulumiTagMarker
public class WorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceArgs = WorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceArgsBuilder.() -> Unit) {
        val builder = WorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workspace {
        val builtJavaResource =
            com.pulumi.azurenative.operationalinsights.Workspace(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Workspace(builtJavaResource)
    }
}

/**
 * The top level Workspace resource container.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2015-11-01-preview, 2020-08-01, 2020-10-01, 2021-06-01, 2021-12-01-preview.
 * ## Example Usage
 * ### WorkspacesCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.OperationalInsights.Workspace("workspace", new()
 *     {
 *         Location = "australiasoutheast",
 *         ResourceGroupName = "oiautorest6685",
 *         RetentionInDays = 30,
 *         Sku = new AzureNative.OperationalInsights.Inputs.WorkspaceSkuArgs
 *         {
 *             Name = "PerGB2018",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "val1" },
 *         },
 *         WorkspaceName = "oiautorest6685",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewWorkspace(ctx, "workspace", &operationalinsights.WorkspaceArgs{
 * 			Location:          pulumi.String("australiasoutheast"),
 * 			ResourceGroupName: pulumi.String("oiautorest6685"),
 * 			RetentionInDays:   pulumi.Int(30),
 * 			Sku: &operationalinsights.WorkspaceSkuArgs{
 * 				Name: pulumi.String("PerGB2018"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("val1"),
 * 			},
 * 			WorkspaceName: pulumi.String("oiautorest6685"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.Workspace;
 * import com.pulumi.azurenative.operationalinsights.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("australiasoutheast")
 *             .resourceGroupName("oiautorest6685")
 *             .retentionInDays(30)
 *             .sku(Map.of("name", "PerGB2018"))
 *             .tags(Map.of("tag1", "val1"))
 *             .workspaceName("oiautorest6685")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:Workspace AzTest2170 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}
 * ```
 */
public class Workspace internal constructor(
    override val javaResource: com.pulumi.azurenative.operationalinsights.Workspace,
) : KotlinCustomResource(javaResource, WorkspaceMapper) {
    /**
     * Workspace creation date.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * This is a read-only property. Represents the ID associated with the workspace.
     */
    public val customerId: Output<String>
        get() = javaResource.customerId().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the default Data Collection Rule to use for this workspace. Expected format is - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
     */
    public val defaultDataCollectionRuleResourceId: Output<String>?
        get() = javaResource.defaultDataCollectionRuleResourceId().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The etag of the workspace.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Workspace features.
     */
    public val features: Output<WorkspaceFeaturesResponse>?
        get() = javaResource.features().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    workspaceFeaturesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Indicates whether customer managed storage is mandatory for query management.
     */
    public val forceCmkForQuery: Output<Boolean>?
        get() = javaResource.forceCmkForQuery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identity of the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Workspace modification date.
     */
    public val modifiedDate: Output<String>
        get() = javaResource.modifiedDate().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of linked private link scope resources.
     */
    public val privateLinkScopedResources: Output<List<PrivateLinkScopedResourceResponse>>
        get() = javaResource.privateLinkScopedResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateLinkScopedResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioning state of the workspace.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The network access type for accessing Log Analytics ingestion.
     */
    public val publicNetworkAccessForIngestion: Output<String>?
        get() = javaResource.publicNetworkAccessForIngestion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The network access type for accessing Log Analytics query.
     */
    public val publicNetworkAccessForQuery: Output<String>?
        get() = javaResource.publicNetworkAccessForQuery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The workspace data retention in days. Allowed values are per pricing plan. See pricing tiers documentation for details.
     */
    public val retentionInDays: Output<Int>?
        get() = javaResource.retentionInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU of the workspace.
     */
    public val sku: Output<WorkspaceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    workspaceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The daily volume cap for ingestion.
     */
    public val workspaceCapping: Output<WorkspaceCappingResponse>?
        get() = javaResource.workspaceCapping().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> workspaceCappingResponseToKotlin(args0) })
            }).orElse(null)
        })
}

public object WorkspaceMapper : ResourceMapper<Workspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationalinsights.Workspace::class == javaResource::class

    override fun map(javaResource: Resource): Workspace = Workspace(
        javaResource as
            com.pulumi.azurenative.operationalinsights.Workspace,
    )
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workspace].
 */
public suspend fun workspace(name: String, block: suspend WorkspaceResourceBuilder.() -> Unit):
    Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspace(name: String): Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
