@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.WorkspaceArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.enums.PublicNetworkAccessType
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.WorkspaceCappingArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.WorkspaceCappingArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.WorkspaceFeaturesArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.WorkspaceFeaturesArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.WorkspaceSkuArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.WorkspaceSkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The top level Workspace resource container.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2015-11-01-preview, 2020-08-01, 2020-10-01, 2021-06-01, 2021-12-01-preview.
 * ## Example Usage
 * ### WorkspacesCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.OperationalInsights.Workspace("workspace", new()
 *     {
 *         Location = "australiasoutheast",
 *         ResourceGroupName = "oiautorest6685",
 *         RetentionInDays = 30,
 *         Sku = new AzureNative.OperationalInsights.Inputs.WorkspaceSkuArgs
 *         {
 *             Name = "PerGB2018",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "val1" },
 *         },
 *         WorkspaceName = "oiautorest6685",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewWorkspace(ctx, "workspace", &operationalinsights.WorkspaceArgs{
 * 			Location:          pulumi.String("australiasoutheast"),
 * 			ResourceGroupName: pulumi.String("oiautorest6685"),
 * 			RetentionInDays:   pulumi.Int(30),
 * 			Sku: &operationalinsights.WorkspaceSkuArgs{
 * 				Name: pulumi.String("PerGB2018"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("val1"),
 * 			},
 * 			WorkspaceName: pulumi.String("oiautorest6685"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.Workspace;
 * import com.pulumi.azurenative.operationalinsights.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("australiasoutheast")
 *             .resourceGroupName("oiautorest6685")
 *             .retentionInDays(30)
 *             .sku(Map.of("name", "PerGB2018"))
 *             .tags(Map.of("tag1", "val1"))
 *             .workspaceName("oiautorest6685")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:Workspace AzTest2170 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}
 * ```
 * @property defaultDataCollectionRuleResourceId The resource ID of the default Data Collection Rule to use for this workspace. Expected format is - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
 * @property features Workspace features.
 * @property forceCmkForQuery Indicates whether customer managed storage is mandatory for query management.
 * @property identity The identity of the resource.
 * @property location The geo-location where the resource lives
 * @property publicNetworkAccessForIngestion The network access type for accessing Log Analytics ingestion.
 * @property publicNetworkAccessForQuery The network access type for accessing Log Analytics query.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property retentionInDays The workspace data retention in days. Allowed values are per pricing plan. See pricing tiers documentation for details.
 * @property sku The SKU of the workspace.
 * @property tags Resource tags.
 * @property workspaceCapping The daily volume cap for ingestion.
 * @property workspaceName The name of the workspace.
 */
public data class WorkspaceArgs(
    public val defaultDataCollectionRuleResourceId: Output<String>? = null,
    public val features: Output<WorkspaceFeaturesArgs>? = null,
    public val forceCmkForQuery: Output<Boolean>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val publicNetworkAccessForIngestion: Output<Either<String, PublicNetworkAccessType>>? =
        null,
    public val publicNetworkAccessForQuery: Output<Either<String, PublicNetworkAccessType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retentionInDays: Output<Int>? = null,
    public val sku: Output<WorkspaceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceCapping: Output<WorkspaceCappingArgs>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.WorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.WorkspaceArgs =
        com.pulumi.azurenative.operationalinsights.WorkspaceArgs.builder()
            .defaultDataCollectionRuleResourceId(
                defaultDataCollectionRuleResourceId?.applyValue({ args0 ->
                    args0
                }),
            )
            .features(features?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forceCmkForQuery(forceCmkForQuery?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .publicNetworkAccessForIngestion(
                publicNetworkAccessForIngestion?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicNetworkAccessForQuery(
                publicNetworkAccessForQuery?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retentionInDays(retentionInDays?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceCapping(workspaceCapping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var defaultDataCollectionRuleResourceId: Output<String>? = null

    private var features: Output<WorkspaceFeaturesArgs>? = null

    private var forceCmkForQuery: Output<Boolean>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var publicNetworkAccessForIngestion: Output<Either<String, PublicNetworkAccessType>>? =
        null

    private var publicNetworkAccessForQuery: Output<Either<String, PublicNetworkAccessType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var retentionInDays: Output<Int>? = null

    private var sku: Output<WorkspaceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceCapping: Output<WorkspaceCappingArgs>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The resource ID of the default Data Collection Rule to use for this workspace. Expected format is - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
     */
    @JvmName("uclotiwrtnubvygh")
    public suspend fun defaultDataCollectionRuleResourceId(`value`: Output<String>) {
        this.defaultDataCollectionRuleResourceId = value
    }

    /**
     * @param value Workspace features.
     */
    @JvmName("pxpkgfthiguoudlr")
    public suspend fun features(`value`: Output<WorkspaceFeaturesArgs>) {
        this.features = value
    }

    /**
     * @param value Indicates whether customer managed storage is mandatory for query management.
     */
    @JvmName("lysffddgryrafhec")
    public suspend fun forceCmkForQuery(`value`: Output<Boolean>) {
        this.forceCmkForQuery = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("kwylpxwbjkdchlig")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("olbldybfqvcuocwy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The network access type for accessing Log Analytics ingestion.
     */
    @JvmName("vrcghplnnqqbosiv")
    public suspend
    fun publicNetworkAccessForIngestion(`value`: Output<Either<String, PublicNetworkAccessType>>) {
        this.publicNetworkAccessForIngestion = value
    }

    /**
     * @param value The network access type for accessing Log Analytics query.
     */
    @JvmName("jwiikxxhbtwecxti")
    public suspend
    fun publicNetworkAccessForQuery(`value`: Output<Either<String, PublicNetworkAccessType>>) {
        this.publicNetworkAccessForQuery = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kaukrqgywhriyhht")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The workspace data retention in days. Allowed values are per pricing plan. See pricing tiers documentation for details.
     */
    @JvmName("sdsiptqlgqxyonmv")
    public suspend fun retentionInDays(`value`: Output<Int>) {
        this.retentionInDays = value
    }

    /**
     * @param value The SKU of the workspace.
     */
    @JvmName("qfuckqoxaxixihoo")
    public suspend fun sku(`value`: Output<WorkspaceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cofoavduxiesmkir")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The daily volume cap for ingestion.
     */
    @JvmName("qebwoyljjkdbfyvj")
    public suspend fun workspaceCapping(`value`: Output<WorkspaceCappingArgs>) {
        this.workspaceCapping = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("hgxouwtdcasklhxt")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The resource ID of the default Data Collection Rule to use for this workspace. Expected format is - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
     */
    @JvmName("mkcxcwnlhnewpsht")
    public suspend fun defaultDataCollectionRuleResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDataCollectionRuleResourceId = mapped
    }

    /**
     * @param value Workspace features.
     */
    @JvmName("msyfmircngpgqfwx")
    public suspend fun features(`value`: WorkspaceFeaturesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param argument Workspace features.
     */
    @JvmName("sqbpxyafkwvnlsox")
    public suspend fun features(argument: suspend WorkspaceFeaturesArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceFeaturesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.features = mapped
    }

    /**
     * @param value Indicates whether customer managed storage is mandatory for query management.
     */
    @JvmName("btgfgtlbhkfefugf")
    public suspend fun forceCmkForQuery(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceCmkForQuery = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("civxwmrvivlenfwi")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("gcgsodtsxiajnlxj")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vgleghtrfjpsfkbm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The network access type for accessing Log Analytics ingestion.
     */
    @JvmName("qgnbbercsncytrmi")
    public suspend
    fun publicNetworkAccessForIngestion(`value`: Either<String, PublicNetworkAccessType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccessForIngestion = mapped
    }

    /**
     * @param value The network access type for accessing Log Analytics ingestion.
     */
    @JvmName("knrccjxefuotjuee")
    public fun publicNetworkAccessForIngestion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccessForIngestion = mapped
    }

    /**
     * @param value The network access type for accessing Log Analytics ingestion.
     */
    @JvmName("kpcahjulxevwwfen")
    public fun publicNetworkAccessForIngestion(`value`: PublicNetworkAccessType) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccessForIngestion = mapped
    }

    /**
     * @param value The network access type for accessing Log Analytics query.
     */
    @JvmName("uichuggdhsrctiwd")
    public suspend
    fun publicNetworkAccessForQuery(`value`: Either<String, PublicNetworkAccessType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccessForQuery = mapped
    }

    /**
     * @param value The network access type for accessing Log Analytics query.
     */
    @JvmName("dwlxklteioumjeti")
    public fun publicNetworkAccessForQuery(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccessForQuery = mapped
    }

    /**
     * @param value The network access type for accessing Log Analytics query.
     */
    @JvmName("wloesfcpnaqmrrgk")
    public fun publicNetworkAccessForQuery(`value`: PublicNetworkAccessType) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccessForQuery = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dlicncpdxsowjbul")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workspace data retention in days. Allowed values are per pricing plan. See pricing tiers documentation for details.
     */
    @JvmName("wytelpkonbgioiub")
    public suspend fun retentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionInDays = mapped
    }

    /**
     * @param value The SKU of the workspace.
     */
    @JvmName("gxwtqeaugrbacaqd")
    public suspend fun sku(`value`: WorkspaceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the workspace.
     */
    @JvmName("mkenyvevvegjoelt")
    public suspend fun sku(argument: suspend WorkspaceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("flfexmultievrytx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fgjysyyqilpbkdux")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The daily volume cap for ingestion.
     */
    @JvmName("jlnkpexjfmtdqnas")
    public suspend fun workspaceCapping(`value`: WorkspaceCappingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceCapping = mapped
    }

    /**
     * @param argument The daily volume cap for ingestion.
     */
    @JvmName("oqjwyhrntufskphb")
    public suspend fun workspaceCapping(argument: suspend WorkspaceCappingArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCappingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.workspaceCapping = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mbmsvwmarogqcoac")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        defaultDataCollectionRuleResourceId = defaultDataCollectionRuleResourceId,
        features = features,
        forceCmkForQuery = forceCmkForQuery,
        identity = identity,
        location = location,
        publicNetworkAccessForIngestion = publicNetworkAccessForIngestion,
        publicNetworkAccessForQuery = publicNetworkAccessForQuery,
        resourceGroupName = resourceGroupName,
        retentionInDays = retentionInDays,
        sku = sku,
        tags = tags,
        workspaceCapping = workspaceCapping,
        workspaceName = workspaceName,
    )
}
