@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.GetQueryPackPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property queryPackName The name of the Log Analytics QueryPack resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetQueryPackPlainArgs(
    public val queryPackName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.GetQueryPackPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.GetQueryPackPlainArgs =
        com.pulumi.azurenative.operationalinsights.inputs.GetQueryPackPlainArgs.builder()
            .queryPackName(queryPackName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetQueryPackPlainArgs].
 */
@PulumiTagMarker
public class GetQueryPackPlainArgsBuilder internal constructor() {
    private var queryPackName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Log Analytics QueryPack resource.
     */
    @JvmName("gvolvdhrvhoapuwm")
    public suspend fun queryPackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.queryPackName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qowyerfkcsxaabqr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetQueryPackPlainArgs = GetQueryPackPlainArgs(
        queryPackName = queryPackName ?: throw PulumiNullFieldException("queryPackName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
