@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.GetQueryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The id of a specific query defined in the Log Analytics QueryPack
 * @property queryPackName The name of the Log Analytics QueryPack resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetQueryPlainArgs(
    public val id: String,
    public val queryPackName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.GetQueryPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.GetQueryPlainArgs =
        com.pulumi.azurenative.operationalinsights.inputs.GetQueryPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .queryPackName(queryPackName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetQueryPlainArgs].
 */
@PulumiTagMarker
public class GetQueryPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var queryPackName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The id of a specific query defined in the Log Analytics QueryPack
     */
    @JvmName("worhsyxittdtbqie")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value The name of the Log Analytics QueryPack resource.
     */
    @JvmName("wsqliwpargucdavh")
    public suspend fun queryPackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.queryPackName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gnccddxchecfmnyd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetQueryPlainArgs = GetQueryPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        queryPackName = queryPackName ?: throw PulumiNullFieldException("queryPackName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
