@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.GetWorkspaceSharedKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group to get. The name is case insensitive.
 * @property workspaceName Name of the Log Analytics Workspace.
 */
public data class GetWorkspaceSharedKeysPlainArgs(
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.GetWorkspaceSharedKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.operationalinsights.inputs.GetWorkspaceSharedKeysPlainArgs =
        com.pulumi.azurenative.operationalinsights.inputs.GetWorkspaceSharedKeysPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceSharedKeysPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceSharedKeysPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group to get. The name is case insensitive.
     */
    @JvmName("gnkskclddaxjywxp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Log Analytics Workspace.
     */
    @JvmName("xrsqksfbamksvwud")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetWorkspaceSharedKeysPlainArgs = GetWorkspaceSharedKeysPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
