@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.LogAnalyticsQueryPackQueryPropertiesRelatedArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The related metadata items for the function.
 * @property categories The related categories for the function.
 * @property resourceTypes The related resource types for the function.
 * @property solutions The related Log Analytics solutions for the function.
 */
public data class LogAnalyticsQueryPackQueryPropertiesRelatedArgs(
    public val categories: Output<List<String>>? = null,
    public val resourceTypes: Output<List<String>>? = null,
    public val solutions: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.LogAnalyticsQueryPackQueryPropertiesRelatedArgs> {
    override fun toJava():
        com.pulumi.azurenative.operationalinsights.inputs.LogAnalyticsQueryPackQueryPropertiesRelatedArgs =
        com.pulumi.azurenative.operationalinsights.inputs.LogAnalyticsQueryPackQueryPropertiesRelatedArgs.builder()
            .categories(categories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceTypes(resourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .solutions(solutions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [LogAnalyticsQueryPackQueryPropertiesRelatedArgs].
 */
@PulumiTagMarker
public class LogAnalyticsQueryPackQueryPropertiesRelatedArgsBuilder internal constructor() {
    private var categories: Output<List<String>>? = null

    private var resourceTypes: Output<List<String>>? = null

    private var solutions: Output<List<String>>? = null

    /**
     * @param value The related categories for the function.
     */
    @JvmName("hacqvfrmfrpoyrfk")
    public suspend fun categories(`value`: Output<List<String>>) {
        this.categories = value
    }

    @JvmName("qiohkmsddgsnailw")
    public suspend fun categories(vararg values: Output<String>) {
        this.categories = Output.all(values.asList())
    }

    /**
     * @param values The related categories for the function.
     */
    @JvmName("cmmcxiwnjecaalki")
    public suspend fun categories(values: List<Output<String>>) {
        this.categories = Output.all(values)
    }

    /**
     * @param value The related resource types for the function.
     */
    @JvmName("pmlfbxxacpxwloix")
    public suspend fun resourceTypes(`value`: Output<List<String>>) {
        this.resourceTypes = value
    }

    @JvmName("qvnerffymdabcknf")
    public suspend fun resourceTypes(vararg values: Output<String>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values The related resource types for the function.
     */
    @JvmName("isulmskgslxoajlh")
    public suspend fun resourceTypes(values: List<Output<String>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value The related Log Analytics solutions for the function.
     */
    @JvmName("xjnhrctqrhfhirtq")
    public suspend fun solutions(`value`: Output<List<String>>) {
        this.solutions = value
    }

    @JvmName("kkluujahyollqyui")
    public suspend fun solutions(vararg values: Output<String>) {
        this.solutions = Output.all(values.asList())
    }

    /**
     * @param values The related Log Analytics solutions for the function.
     */
    @JvmName("kfgujnfnauliptce")
    public suspend fun solutions(values: List<Output<String>>) {
        this.solutions = Output.all(values)
    }

    /**
     * @param value The related categories for the function.
     */
    @JvmName("dnxjyjbhqreyllpb")
    public suspend fun categories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param values The related categories for the function.
     */
    @JvmName("yevpvekkaekcbcgs")
    public suspend fun categories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param value The related resource types for the function.
     */
    @JvmName("mkupkjvfdfmbsdqo")
    public suspend fun resourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param values The related resource types for the function.
     */
    @JvmName("qgjvbprtwcmtkumv")
    public suspend fun resourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param value The related Log Analytics solutions for the function.
     */
    @JvmName("kumkxhwpfoccaaco")
    public suspend fun solutions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.solutions = mapped
    }

    /**
     * @param values The related Log Analytics solutions for the function.
     */
    @JvmName("lplrbpxstddxqqxy")
    public suspend fun solutions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.solutions = mapped
    }

    internal fun build(): LogAnalyticsQueryPackQueryPropertiesRelatedArgs =
        LogAnalyticsQueryPackQueryPropertiesRelatedArgs(
            categories = categories,
            resourceTypes = resourceTypes,
            solutions = solutions,
        )
}
