@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.MachineReferenceWithHintsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A machine reference with a hint of the machine's name and operating system.
 * @property id Resource URI.
 * @property kind Specifies the sub-class of the reference.
 * Expected value is 'ref:machinewithhints'.
 */
public data class MachineReferenceWithHintsArgs(
    public val id: Output<String>,
    public val kind: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.MachineReferenceWithHintsArgs> {
    override fun toJava():
        com.pulumi.azurenative.operationalinsights.inputs.MachineReferenceWithHintsArgs =
        com.pulumi.azurenative.operationalinsights.inputs.MachineReferenceWithHintsArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .kind(kind.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MachineReferenceWithHintsArgs].
 */
@PulumiTagMarker
public class MachineReferenceWithHintsArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var kind: Output<String>? = null

    /**
     * @param value Resource URI.
     */
    @JvmName("yiuipvxnmphxgrfv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Specifies the sub-class of the reference.
     * Expected value is 'ref:machinewithhints'.
     */
    @JvmName("qgcnegfphxnlqyuc")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource URI.
     */
    @JvmName("vltkexxwaouhsyrs")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Specifies the sub-class of the reference.
     * Expected value is 'ref:machinewithhints'.
     */
    @JvmName("tdkymlexflbwytwh")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    internal fun build(): MachineReferenceWithHintsArgs = MachineReferenceWithHintsArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        kind = kind ?: throw PulumiNullFieldException("kind"),
    )
}
