@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.WorkspaceCappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The daily volume cap for ingestion.
 * @property dailyQuotaGb The workspace daily quota for ingestion.
 */
public data class WorkspaceCappingArgs(
    public val dailyQuotaGb: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.WorkspaceCappingArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.WorkspaceCappingArgs =
        com.pulumi.azurenative.operationalinsights.inputs.WorkspaceCappingArgs.builder()
            .dailyQuotaGb(dailyQuotaGb?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceCappingArgs].
 */
@PulumiTagMarker
public class WorkspaceCappingArgsBuilder internal constructor() {
    private var dailyQuotaGb: Output<Double>? = null

    /**
     * @param value The workspace daily quota for ingestion.
     */
    @JvmName("tkucetlawlcivfno")
    public suspend fun dailyQuotaGb(`value`: Output<Double>) {
        this.dailyQuotaGb = value
    }

    /**
     * @param value The workspace daily quota for ingestion.
     */
    @JvmName("wenjehchycgrdhob")
    public suspend fun dailyQuotaGb(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailyQuotaGb = mapped
    }

    internal fun build(): WorkspaceCappingArgs = WorkspaceCappingArgs(
        dailyQuotaGb = dailyQuotaGb,
    )
}
