@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A user-defined logical grouping of machines.
 * @property count Count of machines in this group. The value of count may be bigger than the number of machines in case of the group has been truncated due to exceeding the max number of machines a group can handle.
 * @property displayName User defined name for the group
 * @property etag Resource ETAG.
 * @property groupType Type of the machine group
 * @property id Resource identifier.
 * @property kind Additional resource type qualifier.
 * Expected value is 'machineGroup'.
 * @property machines References of the machines in this group. The hints within each reference do not represent the current value of the corresponding fields. They are a snapshot created during the last time the machine group was updated.
 * @property name Resource name.
 * @property type Resource type.
 */
public data class GetMachineGroupResult(
    public val count: Int? = null,
    public val displayName: String,
    public val etag: String? = null,
    public val groupType: String? = null,
    public val id: String,
    public val kind: String,
    public val machines: List<MachineReferenceWithHintsResponse>? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetMachineGroupResult):
            GetMachineGroupResult = GetMachineGroupResult(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            groupType = javaType.groupType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            machines = javaType.machines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.MachineReferenceWithHintsResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
