@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The private link scope resource reference.
 * @property resourceId The full resource Id of the private link scope resource.
 * @property scopeId The private link scope unique Identifier.
 */
public data class PrivateLinkScopedResourceResponse(
    public val resourceId: String? = null,
    public val scopeId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.PrivateLinkScopedResourceResponse):
            PrivateLinkScopedResourceResponse = PrivateLinkScopedResourceResponse(
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            scopeId = javaType.scopeId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
