@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin

import com.pulumi.azurenative.operationsmanagement.ManagementAssociationArgs.builder
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.ManagementAssociationPropertiesArgs
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.ManagementAssociationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The container for solution.
 * Azure REST API version: 2015-11-01-preview. Prior API version in Azure Native 1.x: 2015-11-01-preview.
 * ## Example Usage
 * ### SolutionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementAssociation = new AzureNative.OperationsManagement.ManagementAssociation("managementAssociation", new()
 *     {
 *         Location = "East US",
 *         ManagementAssociationName = "managementAssociation1",
 *         Properties = new AzureNative.OperationsManagement.Inputs.ManagementAssociationPropertiesArgs
 *         {
 *             ApplicationId = "/subscriptions/sub1/resourcegroups/rg1/providers/Microsoft.Appliance/Appliances/appliance1",
 *         },
 *         ProviderName = "providerName",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "resourceName",
 *         ResourceType = "resourceType",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationsmanagement.NewManagementAssociation(ctx, "managementAssociation", &operationsmanagement.ManagementAssociationArgs{
 * 			Location:                  pulumi.String("East US"),
 * 			ManagementAssociationName: pulumi.String("managementAssociation1"),
 * 			Properties: &operationsmanagement.ManagementAssociationPropertiesArgs{
 * 				ApplicationId: pulumi.String("/subscriptions/sub1/resourcegroups/rg1/providers/Microsoft.Appliance/Appliances/appliance1"),
 * 			},
 * 			ProviderName:      pulumi.String("providerName"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("resourceName"),
 * 			ResourceType:      pulumi.String("resourceType"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationsmanagement.ManagementAssociation;
 * import com.pulumi.azurenative.operationsmanagement.ManagementAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementAssociation = new ManagementAssociation("managementAssociation", ManagementAssociationArgs.builder()
 *             .location("East US")
 *             .managementAssociationName("managementAssociation1")
 *             .properties(Map.of("applicationId", "/subscriptions/sub1/resourcegroups/rg1/providers/Microsoft.Appliance/Appliances/appliance1"))
 *             .providerName("providerName")
 *             .resourceGroupName("rg1")
 *             .resourceName("resourceName")
 *             .resourceType("resourceType")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationsmanagement:ManagementAssociation managementAssociation1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}/providers/Microsoft.OperationsManagement/ManagementAssociations/{managementAssociationName}
 * ```
 * @property location Resource location
 * @property managementAssociationName User ManagementAssociation Name.
 * @property properties Properties for ManagementAssociation object supported by the OperationsManagement resource provider.
 * @property providerName Provider name for the parent resource.
 * @property resourceGroupName The name of the resource group to get. The name is case insensitive.
 * @property resourceName Parent resource name.
 * @property resourceType Resource type for the parent resource
 */
public data class ManagementAssociationArgs(
    public val location: Output<String>? = null,
    public val managementAssociationName: Output<String>? = null,
    public val properties: Output<ManagementAssociationPropertiesArgs>? = null,
    public val providerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationsmanagement.ManagementAssociationArgs> {
    override fun toJava(): com.pulumi.azurenative.operationsmanagement.ManagementAssociationArgs =
        com.pulumi.azurenative.operationsmanagement.ManagementAssociationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .managementAssociationName(managementAssociationName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementAssociationArgs].
 */
@PulumiTagMarker
public class ManagementAssociationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var managementAssociationName: Output<String>? = null

    private var properties: Output<ManagementAssociationPropertiesArgs>? = null

    private var providerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value Resource location
     */
    @JvmName("vrmavlodipaxkage")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value User ManagementAssociation Name.
     */
    @JvmName("lqqewwqawduudoke")
    public suspend fun managementAssociationName(`value`: Output<String>) {
        this.managementAssociationName = value
    }

    /**
     * @param value Properties for ManagementAssociation object supported by the OperationsManagement resource provider.
     */
    @JvmName("paoptwuyriyrutbx")
    public suspend fun properties(`value`: Output<ManagementAssociationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Provider name for the parent resource.
     */
    @JvmName("hoatkwvyevpwgnay")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value The name of the resource group to get. The name is case insensitive.
     */
    @JvmName("jkfcxfrnwugkibpc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Parent resource name.
     */
    @JvmName("ditjphjapldnlaqo")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource type for the parent resource
     */
    @JvmName("xalpweipcyccxtie")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("rdokerjmrujetmrl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value User ManagementAssociation Name.
     */
    @JvmName("yejoyjhyhbmhsvao")
    public suspend fun managementAssociationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementAssociationName = mapped
    }

    /**
     * @param value Properties for ManagementAssociation object supported by the OperationsManagement resource provider.
     */
    @JvmName("ibvqeidsgngaejfd")
    public suspend fun properties(`value`: ManagementAssociationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties for ManagementAssociation object supported by the OperationsManagement resource provider.
     */
    @JvmName("ycttavswbpnutyuc")
    public suspend
    fun properties(argument: suspend ManagementAssociationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementAssociationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Provider name for the parent resource.
     */
    @JvmName("lnymalitcompkkqq")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value The name of the resource group to get. The name is case insensitive.
     */
    @JvmName("wgeywfxmhoglcdtf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parent resource name.
     */
    @JvmName("uuodlwjuoinmixcy")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource type for the parent resource
     */
    @JvmName("tqpthbixvvwsnrhx")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): ManagementAssociationArgs = ManagementAssociationArgs(
        location = location,
        managementAssociationName = managementAssociationName,
        properties = properties,
        providerName = providerName,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        resourceType = resourceType,
    )
}
