@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.inputs

import com.pulumi.azurenative.operationsmanagement.inputs.ArmTemplateParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameter to pass to ARM template
 * @property name name of the parameter.
 * @property value value for the parameter. In Jtoken
 */
public data class ArmTemplateParameterArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationsmanagement.inputs.ArmTemplateParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.operationsmanagement.inputs.ArmTemplateParameterArgs =
        com.pulumi.azurenative.operationsmanagement.inputs.ArmTemplateParameterArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArmTemplateParameterArgs].
 */
@PulumiTagMarker
public class ArmTemplateParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value name of the parameter.
     */
    @JvmName("modxelpkklquqbjf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value value for the parameter. In Jtoken
     */
    @JvmName("faglaulnekfytlpx")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value name of the parameter.
     */
    @JvmName("hvbhljiugujtdxtd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value value for the parameter. In Jtoken
     */
    @JvmName("bpvjaxsdvappuqlk")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ArmTemplateParameterArgs = ArmTemplateParameterArgs(
        name = name,
        `value` = `value`,
    )
}
