@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.inputs

import com.pulumi.azurenative.operationsmanagement.inputs.GetSolutionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group to get. The name is case insensitive.
 * @property solutionName User Solution Name.
 */
public data class GetSolutionPlainArgs(
    public val resourceGroupName: String,
    public val solutionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.operationsmanagement.inputs.GetSolutionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.operationsmanagement.inputs.GetSolutionPlainArgs =
        com.pulumi.azurenative.operationsmanagement.inputs.GetSolutionPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .solutionName(solutionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSolutionPlainArgs].
 */
@PulumiTagMarker
public class GetSolutionPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var solutionName: String? = null

    /**
     * @param value The name of the resource group to get. The name is case insensitive.
     */
    @JvmName("orixkmwjivbnfrmh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value User Solution Name.
     */
    @JvmName("qpqugqvrjlprvttg")
    public suspend fun solutionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.solutionName = mapped
    }

    internal fun build(): GetSolutionPlainArgs = GetSolutionPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        solutionName = solutionName ?: throw PulumiNullFieldException("solutionName"),
    )
}
