@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The container for solution.
 * @property id Resource ID.
 * @property location Resource location
 * @property name Resource name.
 * @property properties Properties for ManagementConfiguration object supported by the OperationsManagement resource provider.
 * @property type Resource type.
 */
public data class GetManagementConfigurationResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: ManagementConfigurationPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationsmanagement.outputs.GetManagementConfigurationResult):
            GetManagementConfigurationResult = GetManagementConfigurationResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.operationsmanagement.kotlin.outputs.ManagementConfigurationPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
