@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.ContactArgs.builder
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactsPropertiesContactProfileArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactsPropertiesContactProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Customer creates a contact resource for a spacecraft resource.
 * Azure REST API version: 2022-11-01.
 * Other available API versions: 2022-03-01.
 * ## Example Usage
 * ### Create a contact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contact = new AzureNative.Orbital.Contact("contact", new()
 *     {
 *         ContactName = "contact1",
 *         ContactProfile = new AzureNative.Orbital.Inputs.ContactsPropertiesContactProfileArgs
 *         {
 *             Id = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/contactProfiles/CONTOSO-CP",
 *         },
 *         GroundStationName = "EASTUS2_0",
 *         ReservationEndTime = "2023-02-22T11:10:45Z",
 *         ReservationStartTime = "2023-02-22T10:58:30Z",
 *         ResourceGroupName = "contoso-Rgp",
 *         SpacecraftName = "CONTOSO_SAT",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewContact(ctx, "contact", &orbital.ContactArgs{
 * 			ContactName: pulumi.String("contact1"),
 * 			ContactProfile: &orbital.ContactsPropertiesContactProfileArgs{
 * 				Id: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/contactProfiles/CONTOSO-CP"),
 * 			},
 * 			GroundStationName:    pulumi.String("EASTUS2_0"),
 * 			ReservationEndTime:   pulumi.String("2023-02-22T11:10:45Z"),
 * 			ReservationStartTime: pulumi.String("2023-02-22T10:58:30Z"),
 * 			ResourceGroupName:    pulumi.String("contoso-Rgp"),
 * 			SpacecraftName:       pulumi.String("CONTOSO_SAT"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.Contact;
 * import com.pulumi.azurenative.orbital.ContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contact = new Contact("contact", ContactArgs.builder()
 *             .contactName("contact1")
 *             .contactProfile(Map.of("id", "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/contactProfiles/CONTOSO-CP"))
 *             .groundStationName("EASTUS2_0")
 *             .reservationEndTime("2023-02-22T11:10:45Z")
 *             .reservationStartTime("2023-02-22T10:58:30Z")
 *             .resourceGroupName("contoso-Rgp")
 *             .spacecraftName("CONTOSO_SAT")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:Contact contact1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/spacecrafts/{spacecraftName}/contacts/{contactName}
 * ```
 * @property contactName Contact name.
 * @property contactProfile The reference to the contact profile resource.
 * @property groundStationName Azure Ground Station name.
 * @property reservationEndTime Reservation end time of a contact (ISO 8601 UTC standard).
 * @property reservationStartTime Reservation start time of a contact (ISO 8601 UTC standard).
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spacecraftName Spacecraft ID.
 */
public data class ContactArgs(
    public val contactName: Output<String>? = null,
    public val contactProfile: Output<ContactsPropertiesContactProfileArgs>? = null,
    public val groundStationName: Output<String>? = null,
    public val reservationEndTime: Output<String>? = null,
    public val reservationStartTime: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val spacecraftName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.ContactArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.ContactArgs =
        com.pulumi.azurenative.orbital.ContactArgs.builder()
            .contactName(contactName?.applyValue({ args0 -> args0 }))
            .contactProfile(contactProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .groundStationName(groundStationName?.applyValue({ args0 -> args0 }))
            .reservationEndTime(reservationEndTime?.applyValue({ args0 -> args0 }))
            .reservationStartTime(reservationStartTime?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .spacecraftName(spacecraftName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactArgs].
 */
@PulumiTagMarker
public class ContactArgsBuilder internal constructor() {
    private var contactName: Output<String>? = null

    private var contactProfile: Output<ContactsPropertiesContactProfileArgs>? = null

    private var groundStationName: Output<String>? = null

    private var reservationEndTime: Output<String>? = null

    private var reservationStartTime: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var spacecraftName: Output<String>? = null

    /**
     * @param value Contact name.
     */
    @JvmName("nbfaawdpsfqmgqwk")
    public suspend fun contactName(`value`: Output<String>) {
        this.contactName = value
    }

    /**
     * @param value The reference to the contact profile resource.
     */
    @JvmName("gsnvwguywjbnhuwg")
    public suspend fun contactProfile(`value`: Output<ContactsPropertiesContactProfileArgs>) {
        this.contactProfile = value
    }

    /**
     * @param value Azure Ground Station name.
     */
    @JvmName("gugkduhuhgrhjatc")
    public suspend fun groundStationName(`value`: Output<String>) {
        this.groundStationName = value
    }

    /**
     * @param value Reservation end time of a contact (ISO 8601 UTC standard).
     */
    @JvmName("nnasebxncvunkhhj")
    public suspend fun reservationEndTime(`value`: Output<String>) {
        this.reservationEndTime = value
    }

    /**
     * @param value Reservation start time of a contact (ISO 8601 UTC standard).
     */
    @JvmName("pjyjwpifuivtvdvp")
    public suspend fun reservationStartTime(`value`: Output<String>) {
        this.reservationStartTime = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hcktcjpefmhiqari")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Spacecraft ID.
     */
    @JvmName("ewxrfhiouxbasoww")
    public suspend fun spacecraftName(`value`: Output<String>) {
        this.spacecraftName = value
    }

    /**
     * @param value Contact name.
     */
    @JvmName("vegfsesmqtvjvcbl")
    public suspend fun contactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactName = mapped
    }

    /**
     * @param value The reference to the contact profile resource.
     */
    @JvmName("kltjfgnbhtdautfe")
    public suspend fun contactProfile(`value`: ContactsPropertiesContactProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactProfile = mapped
    }

    /**
     * @param argument The reference to the contact profile resource.
     */
    @JvmName("plfmjwtfdqdaatfy")
    public suspend
    fun contactProfile(argument: suspend ContactsPropertiesContactProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ContactsPropertiesContactProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.contactProfile = mapped
    }

    /**
     * @param value Azure Ground Station name.
     */
    @JvmName("xyaksjnlxbclfele")
    public suspend fun groundStationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groundStationName = mapped
    }

    /**
     * @param value Reservation end time of a contact (ISO 8601 UTC standard).
     */
    @JvmName("qhurqokjsrxulfym")
    public suspend fun reservationEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservationEndTime = mapped
    }

    /**
     * @param value Reservation start time of a contact (ISO 8601 UTC standard).
     */
    @JvmName("ffshvrrljuqvtblx")
    public suspend fun reservationStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservationStartTime = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vsfuqqjltwlkrvan")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Spacecraft ID.
     */
    @JvmName("jfrokoxdfaakcbxf")
    public suspend fun spacecraftName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spacecraftName = mapped
    }

    internal fun build(): ContactArgs = ContactArgs(
        contactName = contactName,
        contactProfile = contactProfile,
        groundStationName = groundStationName,
        reservationEndTime = reservationEndTime,
        reservationStartTime = reservationStartTime,
        resourceGroupName = resourceGroupName,
        spacecraftName = spacecraftName,
    )
}
