@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.OrbitalFunctions.getContactPlain
import com.pulumi.azurenative.orbital.OrbitalFunctions.getContactProfilePlain
import com.pulumi.azurenative.orbital.OrbitalFunctions.getSpacecraftPlain
import com.pulumi.azurenative.orbital.OrbitalFunctions.listSpacecraftAvailableContactsPlain
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactParametersContactProfile
import com.pulumi.azurenative.orbital.kotlin.inputs.GetContactPlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.GetContactPlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.GetContactProfilePlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.GetContactProfilePlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.GetSpacecraftPlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.GetSpacecraftPlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.ListSpacecraftAvailableContactsPlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.ListSpacecraftAvailableContactsPlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.outputs.GetContactProfileResult
import com.pulumi.azurenative.orbital.kotlin.outputs.GetContactResult
import com.pulumi.azurenative.orbital.kotlin.outputs.GetSpacecraftResult
import com.pulumi.azurenative.orbital.kotlin.outputs.ListSpacecraftAvailableContactsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.orbital.kotlin.outputs.GetContactProfileResult.Companion.toKotlin as getContactProfileResultToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.GetContactResult.Companion.toKotlin as getContactResultToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.GetSpacecraftResult.Companion.toKotlin as getSpacecraftResultToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.ListSpacecraftAvailableContactsResult.Companion.toKotlin as listSpacecraftAvailableContactsResultToKotlin

public object OrbitalFunctions {
    /**
     * Gets the specified contact in a specified resource group.
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-03-01.
     * @param argument null
     * @return Customer creates a contact resource for a spacecraft resource.
     */
    public suspend fun getContact(argument: GetContactPlainArgs): GetContactResult =
        getContactResultToKotlin(getContactPlain(argument.toJava()).await())

    /**
     * @see [getContact].
     * @param contactName Contact name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spacecraftName Spacecraft ID.
     * @return Customer creates a contact resource for a spacecraft resource.
     */
    public suspend fun getContact(
        contactName: String,
        resourceGroupName: String,
        spacecraftName: String,
    ): GetContactResult {
        val argument = GetContactPlainArgs(
            contactName = contactName,
            resourceGroupName = resourceGroupName,
            spacecraftName = spacecraftName,
        )
        return getContactResultToKotlin(getContactPlain(argument.toJava()).await())
    }

    /**
     * @see [getContact].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;GetContactPlainArgs].
     * @return Customer creates a contact resource for a spacecraft resource.
     */
    public suspend fun getContact(argument: suspend GetContactPlainArgsBuilder.() -> Unit):
        GetContactResult {
        val builder = GetContactPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContactResultToKotlin(getContactPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified contact Profile in a specified resource group.
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-03-01.
     * @param argument null
     * @return Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
     */
    public suspend fun getContactProfile(argument: GetContactProfilePlainArgs):
        GetContactProfileResult =
        getContactProfileResultToKotlin(getContactProfilePlain(argument.toJava()).await())

    /**
     * @see [getContactProfile].
     * @param contactProfileName Contact Profile name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
     */
    public suspend fun getContactProfile(contactProfileName: String, resourceGroupName: String):
        GetContactProfileResult {
        val argument = GetContactProfilePlainArgs(
            contactProfileName = contactProfileName,
            resourceGroupName = resourceGroupName,
        )
        return getContactProfileResultToKotlin(getContactProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getContactProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;GetContactProfilePlainArgs].
     * @return Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
     */
    public suspend
    fun getContactProfile(argument: suspend GetContactProfilePlainArgsBuilder.() -> Unit):
        GetContactProfileResult {
        val builder = GetContactProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContactProfileResultToKotlin(getContactProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified spacecraft in a specified resource group.
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-03-01.
     * @param argument null
     * @return Customer creates a spacecraft resource to schedule a contact.
     */
    public suspend fun getSpacecraft(argument: GetSpacecraftPlainArgs): GetSpacecraftResult =
        getSpacecraftResultToKotlin(getSpacecraftPlain(argument.toJava()).await())

    /**
     * @see [getSpacecraft].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spacecraftName Spacecraft ID.
     * @return Customer creates a spacecraft resource to schedule a contact.
     */
    public suspend fun getSpacecraft(resourceGroupName: String, spacecraftName: String):
        GetSpacecraftResult {
        val argument = GetSpacecraftPlainArgs(
            resourceGroupName = resourceGroupName,
            spacecraftName = spacecraftName,
        )
        return getSpacecraftResultToKotlin(getSpacecraftPlain(argument.toJava()).await())
    }

    /**
     * @see [getSpacecraft].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;GetSpacecraftPlainArgs].
     * @return Customer creates a spacecraft resource to schedule a contact.
     */
    public suspend fun getSpacecraft(argument: suspend GetSpacecraftPlainArgsBuilder.() -> Unit):
        GetSpacecraftResult {
        val builder = GetSpacecraftPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSpacecraftResultToKotlin(getSpacecraftPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns list of available contacts. A contact is available if the spacecraft is visible from the ground station for more than the minimum viable contact duration provided in the contact profile.
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-03-01.
     * @param argument null
     * @return Response for the ListAvailableContacts API service call.
     */
    public suspend
    fun listSpacecraftAvailableContacts(argument: ListSpacecraftAvailableContactsPlainArgs):
        ListSpacecraftAvailableContactsResult =
        listSpacecraftAvailableContactsResultToKotlin(listSpacecraftAvailableContactsPlain(argument.toJava()).await())

    /**
     * @see [listSpacecraftAvailableContacts].
     * @param contactProfile The reference to the contact profile resource.
     * @param endTime End time of a contact (ISO 8601 UTC standard).
     * @param groundStationName Name of Azure Ground Station.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spacecraftName Spacecraft ID.
     * @param startTime Start time of a contact (ISO 8601 UTC standard).
     * @return Response for the ListAvailableContacts API service call.
     */
    public suspend fun listSpacecraftAvailableContacts(
        contactProfile: ContactParametersContactProfile,
        endTime: String,
        groundStationName: String,
        resourceGroupName: String,
        spacecraftName: String,
        startTime: String,
    ): ListSpacecraftAvailableContactsResult {
        val argument = ListSpacecraftAvailableContactsPlainArgs(
            contactProfile = contactProfile,
            endTime = endTime,
            groundStationName = groundStationName,
            resourceGroupName = resourceGroupName,
            spacecraftName = spacecraftName,
            startTime = startTime,
        )
        return listSpacecraftAvailableContactsResultToKotlin(listSpacecraftAvailableContactsPlain(argument.toJava()).await())
    }

    /**
     * @see [listSpacecraftAvailableContacts].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;ListSpacecraftAvailableContactsPlainArgs].
     * @return Response for the ListAvailableContacts API service call.
     */
    public suspend
    fun listSpacecraftAvailableContacts(argument: suspend ListSpacecraftAvailableContactsPlainArgsBuilder.() -> Unit):
        ListSpacecraftAvailableContactsResult {
        val builder = ListSpacecraftAvailableContactsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSpacecraftAvailableContactsResultToKotlin(listSpacecraftAvailableContactsPlain(builtArgument.toJava()).await())
    }
}
