@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.GetContactPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contactName Contact name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spacecraftName Spacecraft ID.
 */
public data class GetContactPlainArgs(
    public val contactName: String,
    public val resourceGroupName: String,
    public val spacecraftName: String,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.GetContactPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.GetContactPlainArgs =
        com.pulumi.azurenative.orbital.inputs.GetContactPlainArgs.builder()
            .contactName(contactName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .spacecraftName(spacecraftName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContactPlainArgs].
 */
@PulumiTagMarker
public class GetContactPlainArgsBuilder internal constructor() {
    private var contactName: String? = null

    private var resourceGroupName: String? = null

    private var spacecraftName: String? = null

    /**
     * @param value Contact name.
     */
    @JvmName("gftasplsrbgykeco")
    public suspend fun contactName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.contactName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ookvglgldlirojhi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Spacecraft ID.
     */
    @JvmName("bohpgkslsncrqtkv")
    public suspend fun spacecraftName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.spacecraftName = mapped
    }

    internal fun build(): GetContactPlainArgs = GetContactPlainArgs(
        contactName = contactName ?: throw PulumiNullFieldException("contactName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        spacecraftName = spacecraftName ?: throw PulumiNullFieldException("spacecraftName"),
    )
}
