@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.GetContactProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contactProfileName Contact Profile name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetContactProfilePlainArgs(
    public val contactProfileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.GetContactProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.GetContactProfilePlainArgs =
        com.pulumi.azurenative.orbital.inputs.GetContactProfilePlainArgs.builder()
            .contactProfileName(contactProfileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContactProfilePlainArgs].
 */
@PulumiTagMarker
public class GetContactProfilePlainArgsBuilder internal constructor() {
    private var contactProfileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Contact Profile name.
     */
    @JvmName("vuyeawmjcfrslmsx")
    public suspend fun contactProfileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.contactProfileName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mopkqoiogtrakgjj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetContactProfilePlainArgs = GetContactProfilePlainArgs(
        contactProfileName = contactProfileName ?: throw PulumiNullFieldException("contactProfileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
