@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Customer creates a spacecraft resource to schedule a contact.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property links Immutable list of Spacecraft links.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property noradId NORAD ID of the spacecraft.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property titleLine Title line of the two-line element set (TLE).
 * @property tleLine1 Line 1 of the two-line element set (TLE).
 * @property tleLine2 Line 2 of the two-line element set (TLE).
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSpacecraftResult(
    public val id: String,
    public val links: List<SpacecraftLinkResponse>,
    public val location: String,
    public val name: String,
    public val noradId: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val titleLine: String,
    public val tleLine1: String,
    public val tleLine2: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.GetSpacecraftResult):
            GetSpacecraftResult = GetSpacecraftResult(
            id = javaType.id(),
            links = javaType.links().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.orbital.kotlin.outputs.SpacecraftLinkResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            name = javaType.name(),
            noradId = javaType.noradId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            titleLine = javaType.titleLine(),
            tleLine1 = javaType.tleLine1(),
            tleLine2 = javaType.tleLine2(),
            type = javaType.type(),
        )
    }
}
