@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.azurenative.peering.PeeringArgs.builder
import com.pulumi.azurenative.peering.kotlin.enums.Kind
import com.pulumi.azurenative.peering.kotlin.inputs.PeeringPropertiesDirectArgs
import com.pulumi.azurenative.peering.kotlin.inputs.PeeringPropertiesDirectArgsBuilder
import com.pulumi.azurenative.peering.kotlin.inputs.PeeringPropertiesExchangeArgs
import com.pulumi.azurenative.peering.kotlin.inputs.PeeringPropertiesExchangeArgsBuilder
import com.pulumi.azurenative.peering.kotlin.inputs.PeeringSkuArgs
import com.pulumi.azurenative.peering.kotlin.inputs.PeeringSkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Peering is a logical representation of a set of connections to the Microsoft Cloud Edge at a location.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create a direct peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var peering = new AzureNative.Peering.Peering("peering", new()
 *     {
 *         Direct = new AzureNative.Peering.Inputs.PeeringPropertiesDirectArgs
 *         {
 *             Connections = new[]
 *             {
 *                 new AzureNative.Peering.Inputs.DirectConnectionArgs
 *                 {
 *                     BandwidthInMbps = 10000,
 *                     BgpSession = new AzureNative.Peering.Inputs.BgpSessionArgs
 *                     {
 *                         MaxPrefixesAdvertisedV4 = 1000,
 *                         MaxPrefixesAdvertisedV6 = 100,
 *                         Md5AuthenticationKey = "test-md5-auth-key",
 *                         SessionPrefixV4 = "192.168.0.0/31",
 *                         SessionPrefixV6 = "fd00::0/127",
 *                     },
 *                     ConnectionIdentifier = "5F4CB5C7-6B43-4444-9338-9ABC72606C16",
 *                     PeeringDBFacilityId = 99999,
 *                     SessionAddressProvider = "Peer",
 *                     UseForPeeringService = false,
 *                 },
 *                 new AzureNative.Peering.Inputs.DirectConnectionArgs
 *                 {
 *                     BandwidthInMbps = 10000,
 *                     ConnectionIdentifier = "8AB00818-D533-4504-A25A-03A17F61201C",
 *                     PeeringDBFacilityId = 99999,
 *                     SessionAddressProvider = "Microsoft",
 *                     UseForPeeringService = true,
 *                 },
 *             },
 *             DirectPeeringType = "Edge",
 *             PeerAsn = new AzureNative.Peering.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subId/providers/Microsoft.Peering/peerAsns/myAsn1",
 *             },
 *         },
 *         Kind = "Direct",
 *         Location = "eastus",
 *         PeeringLocation = "peeringLocation0",
 *         PeeringName = "peeringName",
 *         ResourceGroupName = "rgName",
 *         Sku = new AzureNative.Peering.Inputs.PeeringSkuArgs
 *         {
 *             Name = "Basic_Direct_Free",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := peering.NewPeering(ctx, "peering", &peering.PeeringArgs{
 * Direct: peering.PeeringPropertiesDirectResponse{
 * Connections: peering.DirectConnectionArray{
 * interface{}{
 * BandwidthInMbps: pulumi.Int(10000),
 * BgpSession: &peering.BgpSessionArgs{
 * MaxPrefixesAdvertisedV4: pulumi.Int(1000),
 * MaxPrefixesAdvertisedV6: pulumi.Int(100),
 * Md5AuthenticationKey: pulumi.String("test-md5-auth-key"),
 * SessionPrefixV4: pulumi.String("192.168.0.0/31"),
 * SessionPrefixV6: pulumi.String("fd00::0/127"),
 * },
 * ConnectionIdentifier: pulumi.String("5F4CB5C7-6B43-4444-9338-9ABC72606C16"),
 * PeeringDBFacilityId: pulumi.Int(99999),
 * SessionAddressProvider: pulumi.String("Peer"),
 * UseForPeeringService: pulumi.Bool(false),
 * },
 * &peering.DirectConnectionArgs{
 * BandwidthInMbps: pulumi.Int(10000),
 * ConnectionIdentifier: pulumi.String("8AB00818-D533-4504-A25A-03A17F61201C"),
 * PeeringDBFacilityId: pulumi.Int(99999),
 * SessionAddressProvider: pulumi.String("Microsoft"),
 * UseForPeeringService: pulumi.Bool(true),
 * },
 * },
 * DirectPeeringType: pulumi.String("Edge"),
 * PeerAsn: &peering.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subId/providers/Microsoft.Peering/peerAsns/myAsn1"),
 * },
 * },
 * Kind: pulumi.String("Direct"),
 * Location: pulumi.String("eastus"),
 * PeeringLocation: pulumi.String("peeringLocation0"),
 * PeeringName: pulumi.String("peeringName"),
 * ResourceGroupName: pulumi.String("rgName"),
 * Sku: &peering.PeeringSkuArgs{
 * Name: pulumi.String("Basic_Direct_Free"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.Peering;
 * import com.pulumi.azurenative.peering.PeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var peering = new Peering("peering", PeeringArgs.builder()
 *             .direct(Map.ofEntries(
 *                 Map.entry("connections",
 *                     Map.ofEntries(
 *                         Map.entry("bandwidthInMbps", 10000),
 *                         Map.entry("bgpSession", Map.ofEntries(
 *                             Map.entry("maxPrefixesAdvertisedV4", 1000),
 *                             Map.entry("maxPrefixesAdvertisedV6", 100),
 *                             Map.entry("md5AuthenticationKey", "test-md5-auth-key"),
 *                             Map.entry("sessionPrefixV4", "192.168.0.0/31"),
 *                             Map.entry("sessionPrefixV6", "fd00::0/127")
 *                         )),
 *                         Map.entry("connectionIdentifier", "5F4CB5C7-6B43-4444-9338-9ABC72606C16"),
 *                         Map.entry("peeringDBFacilityId", 99999),
 *                         Map.entry("sessionAddressProvider", "Peer"),
 *                         Map.entry("useForPeeringService", false)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("bandwidthInMbps", 10000),
 *                         Map.entry("connectionIdentifier", "8AB00818-D533-4504-A25A-03A17F61201C"),
 *                         Map.entry("peeringDBFacilityId", 99999),
 *                         Map.entry("sessionAddressProvider", "Microsoft"),
 *                         Map.entry("useForPeeringService", true)
 *                     )),
 *                 Map.entry("directPeeringType", "Edge"),
 *                 Map.entry("peerAsn", Map.of("id", "/subscriptions/subId/providers/Microsoft.Peering/peerAsns/myAsn1"))
 *             ))
 *             .kind("Direct")
 *             .location("eastus")
 *             .peeringLocation("peeringLocation0")
 *             .peeringName("peeringName")
 *             .resourceGroupName("rgName")
 *             .sku(Map.of("name", "Basic_Direct_Free"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a peering with exchange route server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var peering = new AzureNative.Peering.Peering("peering", new()
 *     {
 *         Direct = new AzureNative.Peering.Inputs.PeeringPropertiesDirectArgs
 *         {
 *             Connections = new[]
 *             {
 *                 new AzureNative.Peering.Inputs.DirectConnectionArgs
 *                 {
 *                     BandwidthInMbps = 10000,
 *                     BgpSession = new AzureNative.Peering.Inputs.BgpSessionArgs
 *                     {
 *                         MaxPrefixesAdvertisedV4 = 1000,
 *                         MaxPrefixesAdvertisedV6 = 100,
 *                         MicrosoftSessionIPv4Address = "192.168.0.123",
 *                         PeerSessionIPv4Address = "192.168.0.234",
 *                         SessionPrefixV4 = "192.168.0.0/24",
 *                     },
 *                     ConnectionIdentifier = "5F4CB5C7-6B43-4444-9338-9ABC72606C16",
 *                     PeeringDBFacilityId = 99999,
 *                     SessionAddressProvider = "Peer",
 *                     UseForPeeringService = true,
 *                 },
 *             },
 *             DirectPeeringType = "IxRs",
 *             PeerAsn = new AzureNative.Peering.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subId/providers/Microsoft.Peering/peerAsns/myAsn1",
 *             },
 *         },
 *         Kind = "Direct",
 *         Location = "eastus",
 *         PeeringLocation = "peeringLocation0",
 *         PeeringName = "peeringName",
 *         ResourceGroupName = "rgName",
 *         Sku = new AzureNative.Peering.Inputs.PeeringSkuArgs
 *         {
 *             Name = "Premium_Direct_Free",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := peering.NewPeering(ctx, "peering", &peering.PeeringArgs{
 * Direct: peering.PeeringPropertiesDirectResponse{
 * Connections: peering.DirectConnectionArray{
 * interface{}{
 * BandwidthInMbps: pulumi.Int(10000),
 * BgpSession: &peering.BgpSessionArgs{
 * MaxPrefixesAdvertisedV4: pulumi.Int(1000),
 * MaxPrefixesAdvertisedV6: pulumi.Int(100),
 * MicrosoftSessionIPv4Address: pulumi.String("192.168.0.123"),
 * PeerSessionIPv4Address: pulumi.String("192.168.0.234"),
 * SessionPrefixV4: pulumi.String("192.168.0.0/24"),
 * },
 * ConnectionIdentifier: pulumi.String("5F4CB5C7-6B43-4444-9338-9ABC72606C16"),
 * PeeringDBFacilityId: pulumi.Int(99999),
 * SessionAddressProvider: pulumi.String("Peer"),
 * UseForPeeringService: pulumi.Bool(true),
 * },
 * },
 * DirectPeeringType: pulumi.String("IxRs"),
 * PeerAsn: &peering.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subId/providers/Microsoft.Peering/peerAsns/myAsn1"),
 * },
 * },
 * Kind: pulumi.String("Direct"),
 * Location: pulumi.String("eastus"),
 * PeeringLocation: pulumi.String("peeringLocation0"),
 * PeeringName: pulumi.String("peeringName"),
 * ResourceGroupName: pulumi.String("rgName"),
 * Sku: &peering.PeeringSkuArgs{
 * Name: pulumi.String("Premium_Direct_Free"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.Peering;
 * import com.pulumi.azurenative.peering.PeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var peering = new Peering("peering", PeeringArgs.builder()
 *             .direct(Map.ofEntries(
 *                 Map.entry("connections", Map.ofEntries(
 *                     Map.entry("bandwidthInMbps", 10000),
 *                     Map.entry("bgpSession", Map.ofEntries(
 *                         Map.entry("maxPrefixesAdvertisedV4", 1000),
 *                         Map.entry("maxPrefixesAdvertisedV6", 100),
 *                         Map.entry("microsoftSessionIPv4Address", "192.168.0.123"),
 *                         Map.entry("peerSessionIPv4Address", "192.168.0.234"),
 *                         Map.entry("sessionPrefixV4", "192.168.0.0/24")
 *                     )),
 *                     Map.entry("connectionIdentifier", "5F4CB5C7-6B43-4444-9338-9ABC72606C16"),
 *                     Map.entry("peeringDBFacilityId", 99999),
 *                     Map.entry("sessionAddressProvider", "Peer"),
 *                     Map.entry("useForPeeringService", true)
 *                 )),
 *                 Map.entry("directPeeringType", "IxRs"),
 *                 Map.entry("peerAsn", Map.of("id", "/subscriptions/subId/providers/Microsoft.Peering/peerAsns/myAsn1"))
 *             ))
 *             .kind("Direct")
 *             .location("eastus")
 *             .peeringLocation("peeringLocation0")
 *             .peeringName("peeringName")
 *             .resourceGroupName("rgName")
 *             .sku(Map.of("name", "Premium_Direct_Free"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create an exchange peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var peering = new AzureNative.Peering.Peering("peering", new()
 *     {
 *         Exchange = new AzureNative.Peering.Inputs.PeeringPropertiesExchangeArgs
 *         {
 *             Connections = new[]
 *             {
 *                 new AzureNative.Peering.Inputs.ExchangeConnectionArgs
 *                 {
 *                     BgpSession = new AzureNative.Peering.Inputs.BgpSessionArgs
 *                     {
 *                         MaxPrefixesAdvertisedV4 = 1000,
 *                         MaxPrefixesAdvertisedV6 = 100,
 *                         Md5AuthenticationKey = "test-md5-auth-key",
 *                         PeerSessionIPv4Address = "192.168.2.1",
 *                         PeerSessionIPv6Address = "fd00::1",
 *                     },
 *                     ConnectionIdentifier = "CE495334-0E94-4E51-8164-8116D6CD284D",
 *                     PeeringDBFacilityId = 99999,
 *                 },
 *                 new AzureNative.Peering.Inputs.ExchangeConnectionArgs
 *                 {
 *                     BgpSession = new AzureNative.Peering.Inputs.BgpSessionArgs
 *                     {
 *                         MaxPrefixesAdvertisedV4 = 1000,
 *                         MaxPrefixesAdvertisedV6 = 100,
 *                         Md5AuthenticationKey = "test-md5-auth-key",
 *                         PeerSessionIPv4Address = "192.168.2.2",
 *                         PeerSessionIPv6Address = "fd00::2",
 *                     },
 *                     ConnectionIdentifier = "CDD8E673-CB07-47E6-84DE-3739F778762B",
 *                     PeeringDBFacilityId = 99999,
 *                 },
 *             },
 *             PeerAsn = new AzureNative.Peering.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subId/providers/Microsoft.Peering/peerAsns/myAsn1",
 *             },
 *         },
 *         Kind = "Exchange",
 *         Location = "eastus",
 *         PeeringLocation = "peeringLocation0",
 *         PeeringName = "peeringName",
 *         ResourceGroupName = "rgName",
 *         Sku = new AzureNative.Peering.Inputs.PeeringSkuArgs
 *         {
 *             Name = "Basic_Exchange_Free",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := peering.NewPeering(ctx, "peering", &peering.PeeringArgs{
 * Exchange: peering.PeeringPropertiesExchangeResponse{
 * Connections: peering.ExchangeConnectionArray{
 * interface{}{
 * BgpSession: &peering.BgpSessionArgs{
 * MaxPrefixesAdvertisedV4: pulumi.Int(1000),
 * MaxPrefixesAdvertisedV6: pulumi.Int(100),
 * Md5AuthenticationKey: pulumi.String("test-md5-auth-key"),
 * PeerSessionIPv4Address: pulumi.String("192.168.2.1"),
 * PeerSessionIPv6Address: pulumi.String("fd00::1"),
 * },
 * ConnectionIdentifier: pulumi.String("CE495334-0E94-4E51-8164-8116D6CD284D"),
 * PeeringDBFacilityId: pulumi.Int(99999),
 * },
 * interface{}{
 * BgpSession: &peering.BgpSessionArgs{
 * MaxPrefixesAdvertisedV4: pulumi.Int(1000),
 * MaxPrefixesAdvertisedV6: pulumi.Int(100),
 * Md5AuthenticationKey: pulumi.String("test-md5-auth-key"),
 * PeerSessionIPv4Address: pulumi.String("192.168.2.2"),
 * PeerSessionIPv6Address: pulumi.String("fd00::2"),
 * },
 * ConnectionIdentifier: pulumi.String("CDD8E673-CB07-47E6-84DE-3739F778762B"),
 * PeeringDBFacilityId: pulumi.Int(99999),
 * },
 * },
 * PeerAsn: &peering.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subId/providers/Microsoft.Peering/peerAsns/myAsn1"),
 * },
 * },
 * Kind: pulumi.String("Exchange"),
 * Location: pulumi.String("eastus"),
 * PeeringLocation: pulumi.String("peeringLocation0"),
 * PeeringName: pulumi.String("peeringName"),
 * ResourceGroupName: pulumi.String("rgName"),
 * Sku: &peering.PeeringSkuArgs{
 * Name: pulumi.String("Basic_Exchange_Free"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.Peering;
 * import com.pulumi.azurenative.peering.PeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var peering = new Peering("peering", PeeringArgs.builder()
 *             .exchange(Map.ofEntries(
 *                 Map.entry("connections",
 *                     Map.ofEntries(
 *                         Map.entry("bgpSession", Map.ofEntries(
 *                             Map.entry("maxPrefixesAdvertisedV4", 1000),
 *                             Map.entry("maxPrefixesAdvertisedV6", 100),
 *                             Map.entry("md5AuthenticationKey", "test-md5-auth-key"),
 *                             Map.entry("peerSessionIPv4Address", "192.168.2.1"),
 *                             Map.entry("peerSessionIPv6Address", "fd00::1")
 *                         )),
 *                         Map.entry("connectionIdentifier", "CE495334-0E94-4E51-8164-8116D6CD284D"),
 *                         Map.entry("peeringDBFacilityId", 99999)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("bgpSession", Map.ofEntries(
 *                             Map.entry("maxPrefixesAdvertisedV4", 1000),
 *                             Map.entry("maxPrefixesAdvertisedV6", 100),
 *                             Map.entry("md5AuthenticationKey", "test-md5-auth-key"),
 *                             Map.entry("peerSessionIPv4Address", "192.168.2.2"),
 *                             Map.entry("peerSessionIPv6Address", "fd00::2")
 *                         )),
 *                         Map.entry("connectionIdentifier", "CDD8E673-CB07-47E6-84DE-3739F778762B"),
 *                         Map.entry("peeringDBFacilityId", 99999)
 *                     )),
 *                 Map.entry("peerAsn", Map.of("id", "/subscriptions/subId/providers/Microsoft.Peering/peerAsns/myAsn1"))
 *             ))
 *             .kind("Exchange")
 *             .location("eastus")
 *             .peeringLocation("peeringLocation0")
 *             .peeringName("peeringName")
 *             .resourceGroupName("rgName")
 *             .sku(Map.of("name", "Basic_Exchange_Free"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:Peering peeringName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}
 * ```
 * @property direct The properties that define a direct peering.
 * @property exchange The properties that define an exchange peering.
 * @property kind The kind of the peering.
 * @property location The location of the resource.
 * @property peeringLocation The location of the peering.
 * @property peeringName The name of the peering.
 * @property resourceGroupName The name of the resource group.
 * @property sku The SKU that defines the tier and kind of the peering.
 * @property tags The resource tags.
 */
public data class PeeringArgs(
    public val direct: Output<PeeringPropertiesDirectArgs>? = null,
    public val exchange: Output<PeeringPropertiesExchangeArgs>? = null,
    public val kind: Output<Either<String, Kind>>? = null,
    public val location: Output<String>? = null,
    public val peeringLocation: Output<String>? = null,
    public val peeringName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<PeeringSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.PeeringArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.PeeringArgs =
        com.pulumi.azurenative.peering.PeeringArgs.builder()
            .direct(direct?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .exchange(exchange?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .peeringLocation(peeringLocation?.applyValue({ args0 -> args0 }))
            .peeringName(peeringName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PeeringArgs].
 */
@PulumiTagMarker
public class PeeringArgsBuilder internal constructor() {
    private var direct: Output<PeeringPropertiesDirectArgs>? = null

    private var exchange: Output<PeeringPropertiesExchangeArgs>? = null

    private var kind: Output<Either<String, Kind>>? = null

    private var location: Output<String>? = null

    private var peeringLocation: Output<String>? = null

    private var peeringName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<PeeringSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The properties that define a direct peering.
     */
    @JvmName("jjnadkvbfrayymag")
    public suspend fun direct(`value`: Output<PeeringPropertiesDirectArgs>) {
        this.direct = value
    }

    /**
     * @param value The properties that define an exchange peering.
     */
    @JvmName("ljjwyneuilskkcnq")
    public suspend fun exchange(`value`: Output<PeeringPropertiesExchangeArgs>) {
        this.exchange = value
    }

    /**
     * @param value The kind of the peering.
     */
    @JvmName("vcilxnmmvakgavnv")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("inubfucqnmsuujyr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The location of the peering.
     */
    @JvmName("thmwnafqutrvoewx")
    public suspend fun peeringLocation(`value`: Output<String>) {
        this.peeringLocation = value
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("uacujpvgvsfvlnsc")
    public suspend fun peeringName(`value`: Output<String>) {
        this.peeringName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tvvaamhixmpnynbp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU that defines the tier and kind of the peering.
     */
    @JvmName("cahjronjjdrgqwrt")
    public suspend fun sku(`value`: Output<PeeringSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("uymfqnflwouefson")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The properties that define a direct peering.
     */
    @JvmName("npoxdlbamxltkgsf")
    public suspend fun direct(`value`: PeeringPropertiesDirectArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direct = mapped
    }

    /**
     * @param argument The properties that define a direct peering.
     */
    @JvmName("inhewmnbwqidehgb")
    public suspend fun direct(argument: suspend PeeringPropertiesDirectArgsBuilder.() -> Unit) {
        val toBeMapped = PeeringPropertiesDirectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.direct = mapped
    }

    /**
     * @param value The properties that define an exchange peering.
     */
    @JvmName("npcdyfbkhfcoxoku")
    public suspend fun exchange(`value`: PeeringPropertiesExchangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exchange = mapped
    }

    /**
     * @param argument The properties that define an exchange peering.
     */
    @JvmName("bauemrvnmpyvmbse")
    public suspend fun exchange(argument: suspend PeeringPropertiesExchangeArgsBuilder.() -> Unit) {
        val toBeMapped = PeeringPropertiesExchangeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exchange = mapped
    }

    /**
     * @param value The kind of the peering.
     */
    @JvmName("ovdlhysovfudjkrc")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the peering.
     */
    @JvmName("hxjgjcfubdmltqre")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the peering.
     */
    @JvmName("ukxmxgfelkqtxbss")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("ugoybjqcrsbnclbt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The location of the peering.
     */
    @JvmName("vbfobajvwxutwryk")
    public suspend fun peeringLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringLocation = mapped
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("sxkniypwwkodoasi")
    public suspend fun peeringName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("blhvplwhhwjygcbj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU that defines the tier and kind of the peering.
     */
    @JvmName("solewvipbiqcjqqh")
    public suspend fun sku(`value`: PeeringSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU that defines the tier and kind of the peering.
     */
    @JvmName("nxcooawowoewfbae")
    public suspend fun sku(argument: suspend PeeringSkuArgsBuilder.() -> Unit) {
        val toBeMapped = PeeringSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("fsvpprwkmwvcnyuh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("pxrmggcextooxycu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PeeringArgs = PeeringArgs(
        direct = direct,
        exchange = exchange,
        kind = kind,
        location = location,
        peeringLocation = peeringLocation,
        peeringName = peeringName,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
