@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.azurenative.peering.PeeringServiceArgs.builder
import com.pulumi.azurenative.peering.kotlin.inputs.PeeringServiceSkuArgs
import com.pulumi.azurenative.peering.kotlin.inputs.PeeringServiceSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Peering Service
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create a  peering service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var peeringService = new AzureNative.Peering.PeeringService("peeringService", new()
 *     {
 *         Location = "eastus",
 *         PeeringServiceLocation = "state1",
 *         PeeringServiceName = "peeringServiceName",
 *         PeeringServiceProvider = "serviceProvider1",
 *         ProviderBackupPeeringLocation = "peeringLocation2",
 *         ProviderPrimaryPeeringLocation = "peeringLocation1",
 *         ResourceGroupName = "rgName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewPeeringService(ctx, "peeringService", &peering.PeeringServiceArgs{
 * 			Location:                       pulumi.String("eastus"),
 * 			PeeringServiceLocation:         pulumi.String("state1"),
 * 			PeeringServiceName:             pulumi.String("peeringServiceName"),
 * 			PeeringServiceProvider:         pulumi.String("serviceProvider1"),
 * 			ProviderBackupPeeringLocation:  pulumi.String("peeringLocation2"),
 * 			ProviderPrimaryPeeringLocation: pulumi.String("peeringLocation1"),
 * 			ResourceGroupName:              pulumi.String("rgName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.PeeringService;
 * import com.pulumi.azurenative.peering.PeeringServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var peeringService = new PeeringService("peeringService", PeeringServiceArgs.builder()
 *             .location("eastus")
 *             .peeringServiceLocation("state1")
 *             .peeringServiceName("peeringServiceName")
 *             .peeringServiceProvider("serviceProvider1")
 *             .providerBackupPeeringLocation("peeringLocation2")
 *             .providerPrimaryPeeringLocation("peeringLocation1")
 *             .resourceGroupName("rgName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:PeeringService peeringServiceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}
 * ```
 * @property location The location of the resource.
 * @property peeringServiceLocation The location (state/province) of the customer.
 * @property peeringServiceName The name of the peering service.
 * @property peeringServiceProvider The name of the service provider.
 * @property providerBackupPeeringLocation The backup peering (Microsoft/service provider) location to be used for customer traffic.
 * @property providerPrimaryPeeringLocation The primary peering (Microsoft/service provider) location to be used for customer traffic.
 * @property resourceGroupName The name of the resource group.
 * @property sku The SKU that defines the type of the peering service.
 * @property tags The resource tags.
 */
public data class PeeringServiceArgs(
    public val location: Output<String>? = null,
    public val peeringServiceLocation: Output<String>? = null,
    public val peeringServiceName: Output<String>? = null,
    public val peeringServiceProvider: Output<String>? = null,
    public val providerBackupPeeringLocation: Output<String>? = null,
    public val providerPrimaryPeeringLocation: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<PeeringServiceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.PeeringServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.PeeringServiceArgs =
        com.pulumi.azurenative.peering.PeeringServiceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .peeringServiceLocation(peeringServiceLocation?.applyValue({ args0 -> args0 }))
            .peeringServiceName(peeringServiceName?.applyValue({ args0 -> args0 }))
            .peeringServiceProvider(peeringServiceProvider?.applyValue({ args0 -> args0 }))
            .providerBackupPeeringLocation(providerBackupPeeringLocation?.applyValue({ args0 -> args0 }))
            .providerPrimaryPeeringLocation(providerPrimaryPeeringLocation?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PeeringServiceArgs].
 */
@PulumiTagMarker
public class PeeringServiceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var peeringServiceLocation: Output<String>? = null

    private var peeringServiceName: Output<String>? = null

    private var peeringServiceProvider: Output<String>? = null

    private var providerBackupPeeringLocation: Output<String>? = null

    private var providerPrimaryPeeringLocation: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<PeeringServiceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The location of the resource.
     */
    @JvmName("otcjckejbljqjngm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The location (state/province) of the customer.
     */
    @JvmName("pacqcxbakvnunicm")
    public suspend fun peeringServiceLocation(`value`: Output<String>) {
        this.peeringServiceLocation = value
    }

    /**
     * @param value The name of the peering service.
     */
    @JvmName("qhqksgwslsqykxnu")
    public suspend fun peeringServiceName(`value`: Output<String>) {
        this.peeringServiceName = value
    }

    /**
     * @param value The name of the service provider.
     */
    @JvmName("wlhkmcixqiedimci")
    public suspend fun peeringServiceProvider(`value`: Output<String>) {
        this.peeringServiceProvider = value
    }

    /**
     * @param value The backup peering (Microsoft/service provider) location to be used for customer traffic.
     */
    @JvmName("irhynoodkerjgast")
    public suspend fun providerBackupPeeringLocation(`value`: Output<String>) {
        this.providerBackupPeeringLocation = value
    }

    /**
     * @param value The primary peering (Microsoft/service provider) location to be used for customer traffic.
     */
    @JvmName("sdcblujrbifascaa")
    public suspend fun providerPrimaryPeeringLocation(`value`: Output<String>) {
        this.providerPrimaryPeeringLocation = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qqohbjnjkaxypixh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU that defines the type of the peering service.
     */
    @JvmName("hhsgureyfriuvboa")
    public suspend fun sku(`value`: Output<PeeringServiceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("fumqatxcecnnqhut")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("hgupdikpagvnbyfw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The location (state/province) of the customer.
     */
    @JvmName("fowfnaefrrlbpunl")
    public suspend fun peeringServiceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringServiceLocation = mapped
    }

    /**
     * @param value The name of the peering service.
     */
    @JvmName("xmmqsrhbqusveldu")
    public suspend fun peeringServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringServiceName = mapped
    }

    /**
     * @param value The name of the service provider.
     */
    @JvmName("tjjydhuwmnhyllpt")
    public suspend fun peeringServiceProvider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringServiceProvider = mapped
    }

    /**
     * @param value The backup peering (Microsoft/service provider) location to be used for customer traffic.
     */
    @JvmName("toewlpmgisqrcpod")
    public suspend fun providerBackupPeeringLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerBackupPeeringLocation = mapped
    }

    /**
     * @param value The primary peering (Microsoft/service provider) location to be used for customer traffic.
     */
    @JvmName("llshrlsqmkqtpkrc")
    public suspend fun providerPrimaryPeeringLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerPrimaryPeeringLocation = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("idgbmbjbtaxnekes")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU that defines the type of the peering service.
     */
    @JvmName("upapgljiecktucjk")
    public suspend fun sku(`value`: PeeringServiceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU that defines the type of the peering service.
     */
    @JvmName("mmkkhmcpohsektum")
    public suspend fun sku(argument: suspend PeeringServiceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = PeeringServiceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("vibsjssbhmwsxklf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("gcisrwwanvjqbcrx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PeeringServiceArgs = PeeringServiceArgs(
        location = location,
        peeringServiceLocation = peeringServiceLocation,
        peeringServiceName = peeringServiceName,
        peeringServiceProvider = peeringServiceProvider,
        providerBackupPeeringLocation = providerBackupPeeringLocation,
        providerPrimaryPeeringLocation = providerPrimaryPeeringLocation,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
