@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.azurenative.peering.PrefixArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The peering service prefix class.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create or update a prefix for the peering service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prefix = new AzureNative.Peering.Prefix("prefix", new()
 *     {
 *         PeeringServiceName = "peeringServiceName",
 *         PeeringServicePrefixKey = "00000000-0000-0000-0000-000000000000",
 *         Prefix = "192.168.1.0/24",
 *         PrefixName = "peeringServicePrefixName",
 *         ResourceGroupName = "rgName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewPrefix(ctx, "prefix", &peering.PrefixArgs{
 * 			PeeringServiceName:      pulumi.String("peeringServiceName"),
 * 			PeeringServicePrefixKey: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			Prefix:                  pulumi.String("192.168.1.0/24"),
 * 			PrefixName:              pulumi.String("peeringServicePrefixName"),
 * 			ResourceGroupName:       pulumi.String("rgName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.Prefix;
 * import com.pulumi.azurenative.peering.PrefixArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prefix = new Prefix("prefix", PrefixArgs.builder()
 *             .peeringServiceName("peeringServiceName")
 *             .peeringServicePrefixKey("00000000-0000-0000-0000-000000000000")
 *             .prefix("192.168.1.0/24")
 *             .prefixName("peeringServicePrefixName")
 *             .resourceGroupName("rgName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:Prefix peeringServicePrefixName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/prefixes/{prefixName}
 * ```
 * @property peeringServiceName The name of the peering service.
 * @property peeringServicePrefixKey The peering service prefix key
 * @property prefix The prefix from which your traffic originates.
 * @property prefixName The name of the prefix.
 * @property resourceGroupName The name of the resource group.
 */
public data class PrefixArgs(
    public val peeringServiceName: Output<String>? = null,
    public val peeringServicePrefixKey: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val prefixName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.PrefixArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.PrefixArgs =
        com.pulumi.azurenative.peering.PrefixArgs.builder()
            .peeringServiceName(peeringServiceName?.applyValue({ args0 -> args0 }))
            .peeringServicePrefixKey(peeringServicePrefixKey?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .prefixName(prefixName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrefixArgs].
 */
@PulumiTagMarker
public class PrefixArgsBuilder internal constructor() {
    private var peeringServiceName: Output<String>? = null

    private var peeringServicePrefixKey: Output<String>? = null

    private var prefix: Output<String>? = null

    private var prefixName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the peering service.
     */
    @JvmName("pnpcseyotkxyupeh")
    public suspend fun peeringServiceName(`value`: Output<String>) {
        this.peeringServiceName = value
    }

    /**
     * @param value The peering service prefix key
     */
    @JvmName("aodghjmilyugpjmh")
    public suspend fun peeringServicePrefixKey(`value`: Output<String>) {
        this.peeringServicePrefixKey = value
    }

    /**
     * @param value The prefix from which your traffic originates.
     */
    @JvmName("bribgkgrydmggrpb")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The name of the prefix.
     */
    @JvmName("ihmvvmgeulloshlm")
    public suspend fun prefixName(`value`: Output<String>) {
        this.prefixName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lmydtefvyydstvwh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the peering service.
     */
    @JvmName("arnjyiswrapxiapm")
    public suspend fun peeringServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringServiceName = mapped
    }

    /**
     * @param value The peering service prefix key
     */
    @JvmName("ampjfmglvoaolmyc")
    public suspend fun peeringServicePrefixKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringServicePrefixKey = mapped
    }

    /**
     * @param value The prefix from which your traffic originates.
     */
    @JvmName("dqyyliccyqcaygyx")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value The name of the prefix.
     */
    @JvmName("rpnkqsgeubciwpxs")
    public suspend fun prefixName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("iqwsudkplafiimxt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrefixArgs = PrefixArgs(
        peeringServiceName = peeringServiceName,
        peeringServicePrefixKey = peeringServicePrefixKey,
        prefix = prefix,
        prefixName = prefixName,
        resourceGroupName = resourceGroupName,
    )
}
