@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RegisteredAsn].
 */
@PulumiTagMarker
public class RegisteredAsnResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegisteredAsnArgs = RegisteredAsnArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegisteredAsnArgsBuilder.() -> Unit) {
        val builder = RegisteredAsnArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RegisteredAsn {
        val builtJavaResource = com.pulumi.azurenative.peering.RegisteredAsn(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegisteredAsn(builtJavaResource)
    }
}

/**
 * The customer's ASN that is registered by the peering service provider.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create or update a registered ASN for the peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registeredAsn = new AzureNative.Peering.RegisteredAsn("registeredAsn", new()
 *     {
 *         Asn = 65000,
 *         PeeringName = "peeringName",
 *         RegisteredAsnName = "registeredAsnName",
 *         ResourceGroupName = "rgName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewRegisteredAsn(ctx, "registeredAsn", &peering.RegisteredAsnArgs{
 * 			Asn:               pulumi.Int(65000),
 * 			PeeringName:       pulumi.String("peeringName"),
 * 			RegisteredAsnName: pulumi.String("registeredAsnName"),
 * 			ResourceGroupName: pulumi.String("rgName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.RegisteredAsn;
 * import com.pulumi.azurenative.peering.RegisteredAsnArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registeredAsn = new RegisteredAsn("registeredAsn", RegisteredAsnArgs.builder()
 *             .asn(65000)
 *             .peeringName("peeringName")
 *             .registeredAsnName("registeredAsnName")
 *             .resourceGroupName("rgName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:RegisteredAsn registeredAsnName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}/registeredAsns/{registeredAsnName}
 * ```
 */
public class RegisteredAsn internal constructor(
    override val javaResource: com.pulumi.azurenative.peering.RegisteredAsn,
) : KotlinCustomResource(javaResource, RegisteredAsnMapper) {
    /**
     * The customer's ASN from which traffic originates.
     */
    public val asn: Output<Int>?
        get() = javaResource.asn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The peering service prefix key that is to be shared with the customer.
     */
    public val peeringServicePrefixKey: Output<String>
        get() = javaResource.peeringServicePrefixKey().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegisteredAsnMapper : ResourceMapper<RegisteredAsn> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.peering.RegisteredAsn::class == javaResource::class

    override fun map(javaResource: Resource): RegisteredAsn = RegisteredAsn(
        javaResource as
            com.pulumi.azurenative.peering.RegisteredAsn,
    )
}

/**
 * @see [RegisteredAsn].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegisteredAsn].
 */
public suspend fun registeredAsn(
    name: String,
    block: suspend RegisteredAsnResourceBuilder.() -> Unit,
): RegisteredAsn {
    val builder = RegisteredAsnResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegisteredAsn].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registeredAsn(name: String): RegisteredAsn {
    val builder = RegisteredAsnResourceBuilder()
    builder.name(name)
    return builder.build()
}
