@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.azurenative.peering.RegisteredPrefixArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The customer's prefix that is registered by the peering service provider.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create or update a registered prefix for the peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registeredPrefix = new AzureNative.Peering.RegisteredPrefix("registeredPrefix", new()
 *     {
 *         PeeringName = "peeringName",
 *         Prefix = "10.22.20.0/24",
 *         RegisteredPrefixName = "registeredPrefixName",
 *         ResourceGroupName = "rgName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewRegisteredPrefix(ctx, "registeredPrefix", &peering.RegisteredPrefixArgs{
 * 			PeeringName:          pulumi.String("peeringName"),
 * 			Prefix:               pulumi.String("10.22.20.0/24"),
 * 			RegisteredPrefixName: pulumi.String("registeredPrefixName"),
 * 			ResourceGroupName:    pulumi.String("rgName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.RegisteredPrefix;
 * import com.pulumi.azurenative.peering.RegisteredPrefixArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registeredPrefix = new RegisteredPrefix("registeredPrefix", RegisteredPrefixArgs.builder()
 *             .peeringName("peeringName")
 *             .prefix("10.22.20.0/24")
 *             .registeredPrefixName("registeredPrefixName")
 *             .resourceGroupName("rgName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:RegisteredPrefix registeredPrefixName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}/registeredPrefixes/{registeredPrefixName}
 * ```
 * @property peeringName The name of the peering.
 * @property prefix The customer's prefix from which traffic originates.
 * @property registeredPrefixName The name of the registered prefix.
 * @property resourceGroupName The name of the resource group.
 */
public data class RegisteredPrefixArgs(
    public val peeringName: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val registeredPrefixName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.RegisteredPrefixArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.RegisteredPrefixArgs =
        com.pulumi.azurenative.peering.RegisteredPrefixArgs.builder()
            .peeringName(peeringName?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .registeredPrefixName(registeredPrefixName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegisteredPrefixArgs].
 */
@PulumiTagMarker
public class RegisteredPrefixArgsBuilder internal constructor() {
    private var peeringName: Output<String>? = null

    private var prefix: Output<String>? = null

    private var registeredPrefixName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the peering.
     */
    @JvmName("bmllydlhujejgcwb")
    public suspend fun peeringName(`value`: Output<String>) {
        this.peeringName = value
    }

    /**
     * @param value The customer's prefix from which traffic originates.
     */
    @JvmName("qanumtkdfxmdbwfj")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The name of the registered prefix.
     */
    @JvmName("kuegnfpqhyehkccx")
    public suspend fun registeredPrefixName(`value`: Output<String>) {
        this.registeredPrefixName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dmjwxortjnolgkwc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("jjnhrjpuduhpbpol")
    public suspend fun peeringName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringName = mapped
    }

    /**
     * @param value The customer's prefix from which traffic originates.
     */
    @JvmName("ljeaputkdgaydxkt")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value The name of the registered prefix.
     */
    @JvmName("btuhohecwbikdjow")
    public suspend fun registeredPrefixName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registeredPrefixName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hivutpxovdokawfe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): RegisteredPrefixArgs = RegisteredPrefixArgs(
        peeringName = peeringName,
        prefix = prefix,
        registeredPrefixName = registeredPrefixName,
        resourceGroupName = resourceGroupName,
    )
}
