@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The properties that define an exchange connection.
 * @property bgpSession The BGP session associated with the connection.
 * @property connectionIdentifier The unique identifier (GUID) for the connection.
 * @property connectionState The state of the connection.
 * @property errorMessage The error message related to the connection state, if any.
 * @property peeringDBFacilityId The PeeringDB.com ID of the facility at which the connection has to be set up.
 */
public data class ExchangeConnectionResponse(
    public val bgpSession: BgpSessionResponse? = null,
    public val connectionIdentifier: String? = null,
    public val connectionState: String,
    public val errorMessage: String,
    public val peeringDBFacilityId: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.ExchangeConnectionResponse):
            ExchangeConnectionResponse = ExchangeConnectionResponse(
            bgpSession = javaType.bgpSession().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.BgpSessionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionIdentifier = javaType.connectionIdentifier().map({ args0 -> args0 }).orElse(null),
            connectionState = javaType.connectionState(),
            errorMessage = javaType.errorMessage(),
            peeringDBFacilityId = javaType.peeringDBFacilityId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
