@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Peering is a logical representation of a set of connections to the Microsoft Cloud Edge at a location.
 * @property direct The properties that define a direct peering.
 * @property exchange The properties that define an exchange peering.
 * @property id The ID of the resource.
 * @property kind The kind of the peering.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property peeringLocation The location of the peering.
 * @property provisioningState The provisioning state of the resource.
 * @property sku The SKU that defines the tier and kind of the peering.
 * @property tags The resource tags.
 * @property type The type of the resource.
 */
public data class GetPeeringResult(
    public val direct: PeeringPropertiesDirectResponse? = null,
    public val exchange: PeeringPropertiesExchangeResponse? = null,
    public val id: String,
    public val kind: String,
    public val location: String,
    public val name: String,
    public val peeringLocation: String? = null,
    public val provisioningState: String,
    public val sku: PeeringSkuResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.GetPeeringResult):
            GetPeeringResult = GetPeeringResult(
            direct = javaType.direct().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.PeeringPropertiesDirectResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            exchange = javaType.exchange().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.PeeringPropertiesExchangeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location(),
            name = javaType.name(),
            peeringLocation = javaType.peeringLocation().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.peering.kotlin.outputs.PeeringSkuResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
