@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties that define a Log Analytics Workspace.
 * @property connectedAgents The list of connected agents.
 * @property key The Workspace Key.
 * @property workspaceID The Workspace ID.
 */
public data class LogAnalyticsWorkspacePropertiesResponse(
    public val connectedAgents: List<String>,
    public val key: String,
    public val workspaceID: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.LogAnalyticsWorkspacePropertiesResponse):
            LogAnalyticsWorkspacePropertiesResponse = LogAnalyticsWorkspacePropertiesResponse(
            connectedAgents = javaType.connectedAgents().map({ args0 -> args0 }),
            key = javaType.key(),
            workspaceID = javaType.workspaceID(),
        )
    }
}
