@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SKU that defines the tier and kind of the peering.
 * @property family The family of the peering SKU.
 * @property name The name of the peering SKU.
 * @property size The size of the peering SKU.
 * @property tier The tier of the peering SKU.
 */
public data class PeeringSkuResponse(
    public val family: String,
    public val name: String? = null,
    public val size: String,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.PeeringSkuResponse):
            PeeringSkuResponse = PeeringSkuResponse(
            family = javaType.family(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            size = javaType.size(),
            tier = javaType.tier(),
        )
    }
}
