@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtResourceGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attestationName The name of the attestation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAttestationAtResourceGroupPlainArgs(
    public val attestationName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtResourceGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtResourceGroupPlainArgs =
        com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtResourceGroupPlainArgs.builder()
            .attestationName(attestationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAttestationAtResourceGroupPlainArgs].
 */
@PulumiTagMarker
public class GetAttestationAtResourceGroupPlainArgsBuilder internal constructor() {
    private var attestationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the attestation.
     */
    @JvmName("hxfeswxalnuhlcaf")
    public suspend fun attestationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.attestationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hnyobvwsdoxpfqcm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAttestationAtResourceGroupPlainArgs =
        GetAttestationAtResourceGroupPlainArgs(
            attestationName = attestationName ?: throw PulumiNullFieldException("attestationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
