@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.RemediationPropertiesFailureThresholdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The remediation failure threshold settings
 * @property percentage A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
 */
public data class RemediationPropertiesFailureThresholdArgs(
    public val percentage: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.RemediationPropertiesFailureThresholdArgs> {
    override fun toJava():
        com.pulumi.azurenative.policyinsights.inputs.RemediationPropertiesFailureThresholdArgs =
        com.pulumi.azurenative.policyinsights.inputs.RemediationPropertiesFailureThresholdArgs.builder()
            .percentage(percentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RemediationPropertiesFailureThresholdArgs].
 */
@PulumiTagMarker
public class RemediationPropertiesFailureThresholdArgsBuilder internal constructor() {
    private var percentage: Output<Double>? = null

    /**
     * @param value A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
     */
    @JvmName("batmnlfukhesocyh")
    public suspend fun percentage(`value`: Output<Double>) {
        this.percentage = value
    }

    /**
     * @param value A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
     */
    @JvmName("xuengxkkkdwfqmyo")
    public suspend fun percentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentage = mapped
    }

    internal fun build(): RemediationPropertiesFailureThresholdArgs =
        RemediationPropertiesFailureThresholdArgs(
            percentage = percentage,
        )
}
