@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Error definition.
 * @property additionalInfo Additional scenario specific error details.
 * @property code Service specific error code which serves as the substatus for the HTTP error code.
 * @property details Internal error details.
 * @property message Description of the error.
 * @property target The target of the error.
 */
public data class ErrorDefinitionResponse(
    public val additionalInfo: List<TypedErrorInfoResponse>,
    public val code: String,
    public val details: List<ErrorDefinitionResponse>,
    public val message: String,
    public val target: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.policyinsights.outputs.ErrorDefinitionResponse):
            ErrorDefinitionResponse = ErrorDefinitionResponse(
            additionalInfo = javaType.additionalInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.policyinsights.kotlin.outputs.TypedErrorInfoResponse.Companion.toKotlin(args0)
                })
            }),
            code = javaType.code(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.policyinsights.kotlin.outputs.ErrorDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message(),
            target = javaType.target(),
        )
    }
}
