@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An attestation resource.
 * @property assessmentDate The time the evidence was assessed
 * @property comments Comments describing why this attestation was created.
 * @property complianceState The compliance state that should be set on the resource.
 * @property evidence The evidence supporting the compliance state set in this attestation.
 * @property expiresOn The time the compliance state should expire.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastComplianceStateChangeAt The time the compliance state was last changed in this attestation.
 * @property metadata Additional metadata for this attestation
 * @property name The name of the resource
 * @property owner The person responsible for setting the state of the resource. This value is typically an Azure Active Directory object ID.
 * @property policyAssignmentId The resource ID of the policy assignment that the attestation is setting the state for.
 * @property policyDefinitionReferenceId The policy definition reference ID from a policy set definition that the attestation is setting the state for. If the policy assignment assigns a policy set definition the attestation can choose a definition within the set definition with this property or omit this and set the state for the entire set definition.
 * @property provisioningState The status of the attestation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAttestationAtResourceGroupResult(
    public val assessmentDate: String? = null,
    public val comments: String? = null,
    public val complianceState: String? = null,
    public val evidence: List<AttestationEvidenceResponse>? = null,
    public val expiresOn: String? = null,
    public val id: String,
    public val lastComplianceStateChangeAt: String,
    public val metadata: Any? = null,
    public val name: String,
    public val owner: String? = null,
    public val policyAssignmentId: String,
    public val policyDefinitionReferenceId: String? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.policyinsights.outputs.GetAttestationAtResourceGroupResult):
            GetAttestationAtResourceGroupResult = GetAttestationAtResourceGroupResult(
            assessmentDate = javaType.assessmentDate().map({ args0 -> args0 }).orElse(null),
            comments = javaType.comments().map({ args0 -> args0 }).orElse(null),
            complianceState = javaType.complianceState().map({ args0 -> args0 }).orElse(null),
            evidence = javaType.evidence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.policyinsights.kotlin.outputs.AttestationEvidenceResponse.Companion.toKotlin(args0)
                })
            }),
            expiresOn = javaType.expiresOn().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastComplianceStateChangeAt = javaType.lastComplianceStateChangeAt(),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            owner = javaType.owner().map({ args0 -> args0 }).orElse(null),
            policyAssignmentId = javaType.policyAssignmentId(),
            policyDefinitionReferenceId = javaType.policyDefinitionReferenceId().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.policyinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
