@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin

import com.pulumi.azurenative.portal.ConsoleArgs.builder
import com.pulumi.azurenative.portal.kotlin.inputs.ConsoleCreatePropertiesArgs
import com.pulumi.azurenative.portal.kotlin.inputs.ConsoleCreatePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Cloud shell console
 * Azure REST API version: 2018-10-01. Prior API version in Azure Native 1.x: 2018-10-01.
 * ## Example Usage
 * ### PutConsole
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var console = new AzureNative.Portal.Console("console", new()
 *     {
 *         ConsoleName = "default",
 *         Properties = new AzureNative.Portal.Inputs.ConsoleCreatePropertiesArgs
 *         {
 *             OsType = "Linux",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portal/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portal.NewConsole(ctx, "console", &portal.ConsoleArgs{
 * 			ConsoleName: pulumi.String("default"),
 * 			Properties: &portal.ConsoleCreatePropertiesArgs{
 * 				OsType: pulumi.String("Linux"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portal.Console;
 * import com.pulumi.azurenative.portal.ConsoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var console = new Console("console", ConsoleArgs.builder()
 *             .consoleName("default")
 *             .properties(Map.of("osType", "Linux"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portal:Console myresource1 /providers/Microsoft.Portal/consoles/{consoleName}
 * ```
 * @property consoleName The name of the console
 * @property properties Cloud shell properties for creating a console.
 */
public data class ConsoleArgs(
    public val consoleName: Output<String>? = null,
    public val properties: Output<ConsoleCreatePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.ConsoleArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.ConsoleArgs =
        com.pulumi.azurenative.portal.ConsoleArgs.builder()
            .consoleName(consoleName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConsoleArgs].
 */
@PulumiTagMarker
public class ConsoleArgsBuilder internal constructor() {
    private var consoleName: Output<String>? = null

    private var properties: Output<ConsoleCreatePropertiesArgs>? = null

    /**
     * @param value The name of the console
     */
    @JvmName("euxwsrlctandtsql")
    public suspend fun consoleName(`value`: Output<String>) {
        this.consoleName = value
    }

    /**
     * @param value Cloud shell properties for creating a console.
     */
    @JvmName("ruanusiartilkcov")
    public suspend fun properties(`value`: Output<ConsoleCreatePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the console
     */
    @JvmName("rrafbyrfallwkpvf")
    public suspend fun consoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consoleName = mapped
    }

    /**
     * @param value Cloud shell properties for creating a console.
     */
    @JvmName("ypfsmydvplixrjef")
    public suspend fun properties(`value`: ConsoleCreatePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Cloud shell properties for creating a console.
     */
    @JvmName("orpwlpfrmosshftx")
    public suspend fun properties(argument: suspend ConsoleCreatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConsoleCreatePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): ConsoleArgs = ConsoleArgs(
        consoleName = consoleName,
        properties = properties,
    )
}
