@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin

import com.pulumi.azurenative.portal.DashboardArgs.builder
import com.pulumi.azurenative.portal.kotlin.inputs.DashboardLensArgs
import com.pulumi.azurenative.portal.kotlin.inputs.DashboardLensArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The shared dashboard resource definition.
 * Azure REST API version: 2020-09-01-preview. Prior API version in Azure Native 1.x: 2020-09-01-preview.
 * Other available API versions: 2019-01-01-preview.
 * ## Example Usage
 * ### Create or update a Dashboard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dashboard = new AzureNative.Portal.Dashboard("dashboard", new()
 *     {
 *         DashboardName = "testDashboard",
 *         Lenses = new[]
 *         {
 *             new AzureNative.Portal.Inputs.DashboardLensArgs
 *             {
 *                 Order = 1,
 *                 Parts = new[]
 *                 {
 *                     new AzureNative.Portal.Inputs.DashboardPartsArgs
 *                     {
 *                         Position = new AzureNative.Portal.Inputs.DashboardPartsPositionArgs
 *                         {
 *                             ColSpan = 3,
 *                             RowSpan = 4,
 *                             X = 1,
 *                             Y = 2,
 *                         },
 *                     },
 *                     new AzureNative.Portal.Inputs.DashboardPartsArgs
 *                     {
 *                         Position = new AzureNative.Portal.Inputs.DashboardPartsPositionArgs
 *                         {
 *                             ColSpan = 6,
 *                             RowSpan = 6,
 *                             X = 5,
 *                             Y = 5,
 *                         },
 *                     },
 *                 },
 *             },
 *             new AzureNative.Portal.Inputs.DashboardLensArgs
 *             {
 *                 Order = 2,
 *                 Parts = new[] {},
 *             },
 *         },
 *         Location = "eastus",
 *         Metadata =
 *         {
 *             { "metadata",
 *             {
 *                 { "ColSpan", 2 },
 *                 { "RowSpan", 1 },
 *                 { "X", 4 },
 *                 { "Y", 3 },
 *             } },
 *         },
 *         ResourceGroupName = "testRG",
 *         Tags =
 *         {
 *             { "aKey", "aValue" },
 *             { "anotherKey", "anotherValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portal/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portal.NewDashboard(ctx, "dashboard", &portal.DashboardArgs{
 * 			DashboardName: pulumi.String("testDashboard"),
 * 			Lenses: []portal.DashboardLensArgs{
 * 				{
 * 					Order: pulumi.Int(1),
 * 					Parts: []portal.DashboardPartsArgs{
 * 						{
 * 							Position: {
 * 								ColSpan: pulumi.Int(3),
 * 								RowSpan: pulumi.Int(4),
 * 								X:       pulumi.Int(1),
 * 								Y:       pulumi.Int(2),
 * 							},
 * 						},
 * 						{
 * 							Position: {
 * 								ColSpan: pulumi.Int(6),
 * 								RowSpan: pulumi.Int(6),
 * 								X:       pulumi.Int(5),
 * 								Y:       pulumi.Int(5),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				{
 * 					Order: pulumi.Int(2),
 * 					Parts: portal.DashboardPartsArray{},
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Metadata: pulumi.Map{
 * 				"metadata": pulumi.Any{
 * 					ColSpan: 2,
 * 					RowSpan: 1,
 * 					X:       4,
 * 					Y:       3,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 			Tags: pulumi.StringMap{
 * 				"aKey":       pulumi.String("aValue"),
 * 				"anotherKey": pulumi.String("anotherValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portal.Dashboard;
 * import com.pulumi.azurenative.portal.DashboardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dashboard = new Dashboard("dashboard", DashboardArgs.builder()
 *             .dashboardName("testDashboard")
 *             .lenses(
 *                 Map.ofEntries(
 *                     Map.entry("order", 1),
 *                     Map.entry("parts",
 *                         Map.of("position", Map.ofEntries(
 *                             Map.entry("colSpan", 3),
 *                             Map.entry("rowSpan", 4),
 *                             Map.entry("x", 1),
 *                             Map.entry("y", 2)
 *                         )),
 *                         Map.of("position", Map.ofEntries(
 *                             Map.entry("colSpan", 6),
 *                             Map.entry("rowSpan", 6),
 *                             Map.entry("x", 5),
 *                             Map.entry("y", 5)
 *                         )))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("order", 2),
 *                     Map.entry("parts", )
 *                 ))
 *             .location("eastus")
 *             .metadata(Map.of("metadata", Map.ofEntries(
 *                 Map.entry("ColSpan", 2),
 *                 Map.entry("RowSpan", 1),
 *                 Map.entry("X", 4),
 *                 Map.entry("Y", 3)
 *             )))
 *             .resourceGroupName("testRG")
 *             .tags(Map.ofEntries(
 *                 Map.entry("aKey", "aValue"),
 *                 Map.entry("anotherKey", "anotherValue")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portal:Dashboard testDashboard /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Portal/dashboards/{dashboardName}
 * ```
 * @property dashboardName The name of the dashboard.
 * @property lenses The dashboard lenses.
 * @property location Resource location
 * @property metadata The dashboard metadata.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags
 */
public data class DashboardArgs(
    public val dashboardName: Output<String>? = null,
    public val lenses: Output<List<DashboardLensArgs>>? = null,
    public val location: Output<String>? = null,
    public val metadata: Output<Map<String, Any>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.DashboardArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.DashboardArgs =
        com.pulumi.azurenative.portal.DashboardArgs.builder()
            .dashboardName(dashboardName?.applyValue({ args0 -> args0 }))
            .lenses(lenses?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DashboardArgs].
 */
@PulumiTagMarker
public class DashboardArgsBuilder internal constructor() {
    private var dashboardName: Output<String>? = null

    private var lenses: Output<List<DashboardLensArgs>>? = null

    private var location: Output<String>? = null

    private var metadata: Output<Map<String, Any>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the dashboard.
     */
    @JvmName("dykwjgmckyxodvgt")
    public suspend fun dashboardName(`value`: Output<String>) {
        this.dashboardName = value
    }

    /**
     * @param value The dashboard lenses.
     */
    @JvmName("jowxqhwlnvrejbcw")
    public suspend fun lenses(`value`: Output<List<DashboardLensArgs>>) {
        this.lenses = value
    }

    @JvmName("jjcbmbjcokfeejkp")
    public suspend fun lenses(vararg values: Output<DashboardLensArgs>) {
        this.lenses = Output.all(values.asList())
    }

    /**
     * @param values The dashboard lenses.
     */
    @JvmName("xivfcvwttpryymqt")
    public suspend fun lenses(values: List<Output<DashboardLensArgs>>) {
        this.lenses = Output.all(values)
    }

    /**
     * @param value Resource location
     */
    @JvmName("sgwsgbacafnlqqjn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The dashboard metadata.
     */
    @JvmName("oqmnhtbihmxrwwnn")
    public suspend fun metadata(`value`: Output<Map<String, Any>>) {
        this.metadata = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rclnftdirhpehgfe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("scqpccjppjgmpwvv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the dashboard.
     */
    @JvmName("vqognlrjwtkkions")
    public suspend fun dashboardName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardName = mapped
    }

    /**
     * @param value The dashboard lenses.
     */
    @JvmName("xomybcdbundllflm")
    public suspend fun lenses(`value`: List<DashboardLensArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lenses = mapped
    }

    /**
     * @param argument The dashboard lenses.
     */
    @JvmName("dolvrrvenuyvioic")
    public suspend fun lenses(argument: List<suspend DashboardLensArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardLensArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.lenses = mapped
    }

    /**
     * @param argument The dashboard lenses.
     */
    @JvmName("caswbapceagtxkdq")
    public suspend fun lenses(vararg argument: suspend DashboardLensArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DashboardLensArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.lenses = mapped
    }

    /**
     * @param argument The dashboard lenses.
     */
    @JvmName("gqogljffqbatgqoy")
    public suspend fun lenses(argument: suspend DashboardLensArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DashboardLensArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lenses = mapped
    }

    /**
     * @param values The dashboard lenses.
     */
    @JvmName("dsaghejwlhfdirtf")
    public suspend fun lenses(vararg values: DashboardLensArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lenses = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("aoimeijdkmsiierg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The dashboard metadata.
     */
    @JvmName("adnxlxtdpnfokquy")
    public suspend fun metadata(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values The dashboard metadata.
     */
    @JvmName("bvpighgvjkeofbxi")
    public fun metadata(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jdwaisdwtluojqhm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("pvvrrgesehlchrjp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("mthcifkretevltbt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DashboardArgs = DashboardArgs(
        dashboardName = dashboardName,
        lenses = lenses,
        location = location,
        metadata = metadata,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
