@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.DashboardLensArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A dashboard lens.
 * @property metadata The dashboard len's metadata.
 * @property order The lens order.
 * @property parts The dashboard parts.
 */
public data class DashboardLensArgs(
    public val metadata: Output<Map<String, Any>>? = null,
    public val order: Output<Int>,
    public val parts: Output<List<DashboardPartsArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.DashboardLensArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.DashboardLensArgs =
        com.pulumi.azurenative.portal.inputs.DashboardLensArgs.builder()
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .order(order.applyValue({ args0 -> args0 }))
            .parts(
                parts.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DashboardLensArgs].
 */
@PulumiTagMarker
public class DashboardLensArgsBuilder internal constructor() {
    private var metadata: Output<Map<String, Any>>? = null

    private var order: Output<Int>? = null

    private var parts: Output<List<DashboardPartsArgs>>? = null

    /**
     * @param value The dashboard len's metadata.
     */
    @JvmName("vhpdfcdvytaurbvr")
    public suspend fun metadata(`value`: Output<Map<String, Any>>) {
        this.metadata = value
    }

    /**
     * @param value The lens order.
     */
    @JvmName("kkcswrltdwsvmfei")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value The dashboard parts.
     */
    @JvmName("bvdarnocxlrjcdqc")
    public suspend fun parts(`value`: Output<List<DashboardPartsArgs>>) {
        this.parts = value
    }

    @JvmName("bkvddcacwsivwhve")
    public suspend fun parts(vararg values: Output<DashboardPartsArgs>) {
        this.parts = Output.all(values.asList())
    }

    /**
     * @param values The dashboard parts.
     */
    @JvmName("kpykmplgiwiwcmky")
    public suspend fun parts(values: List<Output<DashboardPartsArgs>>) {
        this.parts = Output.all(values)
    }

    /**
     * @param value The dashboard len's metadata.
     */
    @JvmName("yrdhjjponislfrku")
    public suspend fun metadata(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values The dashboard len's metadata.
     */
    @JvmName("dqyhqeccsmyufqqh")
    public fun metadata(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The lens order.
     */
    @JvmName("clwwpvkxggbaofhm")
    public suspend fun order(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value The dashboard parts.
     */
    @JvmName("jqqiinyyqslssbfd")
    public suspend fun parts(`value`: List<DashboardPartsArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parts = mapped
    }

    /**
     * @param argument The dashboard parts.
     */
    @JvmName("ugcubfqasgyfionf")
    public suspend fun parts(argument: List<suspend DashboardPartsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardPartsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parts = mapped
    }

    /**
     * @param argument The dashboard parts.
     */
    @JvmName("trolryvlnrcpawnj")
    public suspend fun parts(vararg argument: suspend DashboardPartsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DashboardPartsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parts = mapped
    }

    /**
     * @param argument The dashboard parts.
     */
    @JvmName("kinhycfhbyxwtiye")
    public suspend fun parts(argument: suspend DashboardPartsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DashboardPartsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parts = mapped
    }

    /**
     * @param values The dashboard parts.
     */
    @JvmName("ovpcpooiqgyrcnmi")
    public suspend fun parts(vararg values: DashboardPartsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parts = mapped
    }

    internal fun build(): DashboardLensArgs = DashboardLensArgs(
        metadata = metadata,
        order = order ?: throw PulumiNullFieldException("order"),
        parts = parts ?: throw PulumiNullFieldException("parts"),
    )
}
