@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.GetDashboardPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dashboardName The name of the dashboard.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetDashboardPlainArgs(
    public val dashboardName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.GetDashboardPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.GetDashboardPlainArgs =
        com.pulumi.azurenative.portal.inputs.GetDashboardPlainArgs.builder()
            .dashboardName(dashboardName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDashboardPlainArgs].
 */
@PulumiTagMarker
public class GetDashboardPlainArgsBuilder internal constructor() {
    private var dashboardName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the dashboard.
     */
    @JvmName("wraikrukdfoootuy")
    public suspend fun dashboardName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dashboardName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ykopmxrnrgmctrib")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDashboardPlainArgs = GetDashboardPlainArgs(
        dashboardName = dashboardName ?: throw PulumiNullFieldException("dashboardName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
