@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.GetUserSettingsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property userSettingsName The name of the user settings
 */
public data class GetUserSettingsPlainArgs(
    public val userSettingsName: String,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.GetUserSettingsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.GetUserSettingsPlainArgs =
        com.pulumi.azurenative.portal.inputs.GetUserSettingsPlainArgs.builder()
            .userSettingsName(userSettingsName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserSettingsPlainArgs].
 */
@PulumiTagMarker
public class GetUserSettingsPlainArgsBuilder internal constructor() {
    private var userSettingsName: String? = null

    /**
     * @param value The name of the user settings
     */
    @JvmName("khxwokwcrcvrdnmb")
    public suspend fun userSettingsName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userSettingsName = mapped
    }

    internal fun build(): GetUserSettingsPlainArgs = GetUserSettingsPlainArgs(
        userSettingsName = userSettingsName ?: throw PulumiNullFieldException("userSettingsName"),
    )
}
