@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Markdown part metadata.
 * @property inputs Input to dashboard part.
 * @property settings Markdown part settings.
 * @property type The type of dashboard part.
 * Expected value is 'Extension/HubsExtension/PartType/MarkdownPart'.
 */
public data class MarkdownPartMetadataArgs(
    public val inputs: Output<List<Any>>? = null,
    public val settings: Output<MarkdownPartMetadataSettingsArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataArgs =
        com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataArgs.builder()
            .inputs(inputs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MarkdownPartMetadataArgs].
 */
@PulumiTagMarker
public class MarkdownPartMetadataArgsBuilder internal constructor() {
    private var inputs: Output<List<Any>>? = null

    private var settings: Output<MarkdownPartMetadataSettingsArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Input to dashboard part.
     */
    @JvmName("ndhdckspflslvdtd")
    public suspend fun inputs(`value`: Output<List<Any>>) {
        this.inputs = value
    }

    @JvmName("byqrmdhjbrhbewvo")
    public suspend fun inputs(vararg values: Output<Any>) {
        this.inputs = Output.all(values.asList())
    }

    /**
     * @param values Input to dashboard part.
     */
    @JvmName("twpptxiucfukbhtd")
    public suspend fun inputs(values: List<Output<Any>>) {
        this.inputs = Output.all(values)
    }

    /**
     * @param value Markdown part settings.
     */
    @JvmName("vidtlqumsdatlqgr")
    public suspend fun settings(`value`: Output<MarkdownPartMetadataSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value The type of dashboard part.
     * Expected value is 'Extension/HubsExtension/PartType/MarkdownPart'.
     */
    @JvmName("vtglqptrawhpmgue")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Input to dashboard part.
     */
    @JvmName("mcrxypecrmleebwm")
    public suspend fun inputs(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param values Input to dashboard part.
     */
    @JvmName("aplfvbaummrdigbj")
    public suspend fun inputs(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value Markdown part settings.
     */
    @JvmName("fodcmannghpsurom")
    public suspend fun settings(`value`: MarkdownPartMetadataSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Markdown part settings.
     */
    @JvmName("hwyvjsdrmqkctypi")
    public suspend
    fun settings(argument: suspend MarkdownPartMetadataSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MarkdownPartMetadataSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param value The type of dashboard part.
     * Expected value is 'Extension/HubsExtension/PartType/MarkdownPart'.
     */
    @JvmName("fjeddkuyjewqywij")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MarkdownPartMetadataArgs = MarkdownPartMetadataArgs(
        inputs = inputs,
        settings = settings,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
