@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings for terminal appearance.
 * @property fontSize Size of terminal font.
 * @property fontStyle Style of terminal font.
 */
public data class TerminalSettingsResponse(
    public val fontSize: String? = null,
    public val fontStyle: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.TerminalSettingsResponse):
            TerminalSettingsResponse = TerminalSettingsResponse(
            fontSize = javaType.fontSize().map({ args0 -> args0 }).orElse(null),
            fontStyle = javaType.fontStyle().map({ args0 -> args0 }).orElse(null),
        )
    }
}
