@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin

import com.pulumi.azurenative.powerbi.kotlin.outputs.AzureSkuResponse
import com.pulumi.azurenative.powerbi.kotlin.outputs.AzureSkuResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [WorkspaceCollection].
 */
@PulumiTagMarker
public class WorkspaceCollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceCollectionArgs = WorkspaceCollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceCollectionArgsBuilder.() -> Unit) {
        val builder = WorkspaceCollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkspaceCollection {
        val builtJavaResource =
            com.pulumi.azurenative.powerbi.WorkspaceCollection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceCollection(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2016-01-29. Prior API version in Azure Native 1.x: 2016-01-29.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:powerbi:WorkspaceCollection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/workspaceCollections/{workspaceCollectionName}
 * ```
 */
public class WorkspaceCollection internal constructor(
    override val javaResource: com.pulumi.azurenative.powerbi.WorkspaceCollection,
) : KotlinCustomResource(javaResource, WorkspaceCollectionMapper) {
    /**
     * Azure location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Workspace collection name
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Properties
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    public val sku: Output<AzureSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object WorkspaceCollectionMapper : ResourceMapper<WorkspaceCollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.powerbi.WorkspaceCollection::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceCollection = WorkspaceCollection(
        javaResource
            as com.pulumi.azurenative.powerbi.WorkspaceCollection,
    )
}

/**
 * @see [WorkspaceCollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceCollection].
 */
public suspend fun workspaceCollection(
    name: String,
    block: suspend WorkspaceCollectionResourceBuilder.() -> Unit,
): WorkspaceCollection {
    val builder = WorkspaceCollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceCollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceCollection(name: String): WorkspaceCollection {
    val builder = WorkspaceCollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
