@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin.inputs

import com.pulumi.azurenative.powerbi.inputs.ConnectionStateArgs.builder
import com.pulumi.azurenative.powerbi.kotlin.enums.PersistedConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ConnectionState information.
 * @property actionsRequired Actions required (if any).
 * @property description Description of the connection state.
 * @property status Status of the connection.
 */
public data class ConnectionStateArgs(
    public val actionsRequired: Output<String>? = null,
    public val description: Output<String>? = null,
    public val status: Output<Either<String, PersistedConnectionStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerbi.inputs.ConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbi.inputs.ConnectionStateArgs =
        com.pulumi.azurenative.powerbi.inputs.ConnectionStateArgs.builder()
            .actionsRequired(actionsRequired?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionStateArgs].
 */
@PulumiTagMarker
public class ConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<Either<String, PersistedConnectionStatus>>? = null

    /**
     * @param value Actions required (if any).
     */
    @JvmName("sbaqguklmmrmbhyp")
    public suspend fun actionsRequired(`value`: Output<String>) {
        this.actionsRequired = value
    }

    /**
     * @param value Description of the connection state.
     */
    @JvmName("fpwapjynvkfvxyre")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Status of the connection.
     */
    @JvmName("grmiewhkrxxnynfn")
    public suspend fun status(`value`: Output<Either<String, PersistedConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value Actions required (if any).
     */
    @JvmName("yawekqtscnfjceuu")
    public suspend fun actionsRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value Description of the connection state.
     */
    @JvmName("licbeuqbcepkfttq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Status of the connection.
     */
    @JvmName("sbevumrlhkrldfiu")
    public suspend fun status(`value`: Either<String, PersistedConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the connection.
     */
    @JvmName("ownarjjbwdenijsv")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PersistedConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the connection.
     */
    @JvmName("ledxwyjrdnwuyksm")
    public fun status(`value`: PersistedConnectionStatus) {
        val toBeMapped = Either.ofRight<String, PersistedConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ConnectionStateArgs = ConnectionStateArgs(
        actionsRequired = actionsRequired,
        description = description,
        status = status,
    )
}
