@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin

import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.CapacitySkuResponse
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.DedicatedCapacityAdministratorsResponse
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.CapacitySkuResponse.Companion.toKotlin as capacitySkuResponseToKotlin
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.DedicatedCapacityAdministratorsResponse.Companion.toKotlin as dedicatedCapacityAdministratorsResponseToKotlin
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CapacityDetails].
 */
@PulumiTagMarker
public class CapacityDetailsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CapacityDetailsArgs = CapacityDetailsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CapacityDetailsArgsBuilder.() -> Unit) {
        val builder = CapacityDetailsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CapacityDetails {
        val builtJavaResource =
            com.pulumi.azurenative.powerbidedicated.CapacityDetails(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CapacityDetails(builtJavaResource)
    }
}

/**
 * Represents an instance of a Dedicated Capacity resource.
 * Azure REST API version: 2021-01-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2017-10-01.
 * ## Example Usage
 * ### Create capacity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var capacityDetails = new AzureNative.PowerBIDedicated.CapacityDetails("capacityDetails", new()
 *     {
 *         Administration = new AzureNative.PowerBIDedicated.Inputs.DedicatedCapacityAdministratorsArgs
 *         {
 *             Members = new[]
 *             {
 *                 "azsdktest@microsoft.com",
 *                 "azsdktest2@microsoft.com",
 *             },
 *         },
 *         DedicatedCapacityName = "azsdktest",
 *         Location = "West US",
 *         ResourceGroupName = "TestRG",
 *         Sku = new AzureNative.PowerBIDedicated.Inputs.CapacitySkuArgs
 *         {
 *             Name = "A1",
 *             Tier = "PBIE_Azure",
 *         },
 *         Tags =
 *         {
 *             { "testKey", "testValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/powerbidedicated/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := powerbidedicated.NewCapacityDetails(ctx, "capacityDetails", &powerbidedicated.CapacityDetailsArgs{
 * 			Administration: &powerbidedicated.DedicatedCapacityAdministratorsArgs{
 * 				Members: pulumi.StringArray{
 * 					pulumi.String("azsdktest@microsoft.com"),
 * 					pulumi.String("azsdktest2@microsoft.com"),
 * 				},
 * 			},
 * 			DedicatedCapacityName: pulumi.String("azsdktest"),
 * 			Location:              pulumi.String("West US"),
 * 			ResourceGroupName:     pulumi.String("TestRG"),
 * 			Sku: &powerbidedicated.CapacitySkuArgs{
 * 				Name: pulumi.String("A1"),
 * 				Tier: pulumi.String("PBIE_Azure"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"testKey": pulumi.String("testValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.powerbidedicated.CapacityDetails;
 * import com.pulumi.azurenative.powerbidedicated.CapacityDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var capacityDetails = new CapacityDetails("capacityDetails", CapacityDetailsArgs.builder()
 *             .administration(Map.of("members",
 *                 "azsdktest@microsoft.com",
 *                 "azsdktest2@microsoft.com"))
 *             .dedicatedCapacityName("azsdktest")
 *             .location("West US")
 *             .resourceGroupName("TestRG")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "A1"),
 *                 Map.entry("tier", "PBIE_Azure")
 *             ))
 *             .tags(Map.of("testKey", "testValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:powerbidedicated:CapacityDetails azsdktest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/capacities/{dedicatedCapacityName}
 * ```
 */
public class CapacityDetails internal constructor(
    override val javaResource: com.pulumi.azurenative.powerbidedicated.CapacityDetails,
) : KotlinCustomResource(javaResource, CapacityDetailsMapper) {
    /**
     * A collection of Dedicated capacity administrators
     */
    public val administration: Output<DedicatedCapacityAdministratorsResponse>?
        get() = javaResource.administration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dedicatedCapacityAdministratorsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Capacity name
     */
    public val friendlyName: Output<String>
        get() = javaResource.friendlyName().applyValue({ args0 -> args0 })

    /**
     * Location of the PowerBI Dedicated resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
     */
    public val mode: Output<String>?
        get() = javaResource.mode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the PowerBI Dedicated resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current deployment state of PowerBI Dedicated resource. The provisioningState is to indicate states for resource provisioning.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The SKU of the PowerBI Dedicated capacity resource.
     */
    public val sku: Output<CapacitySkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                capacitySkuResponseToKotlin(args0)
            })
        })

    /**
     * The current state of PowerBI Dedicated resource. The state is to indicate more states outside of resource provisioning.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>?
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    systemDataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Key-value pairs of additional resource provisioning properties.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Tenant ID for the capacity. Used for creating Pro Plus capacity.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * The type of the PowerBI Dedicated resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CapacityDetailsMapper : ResourceMapper<CapacityDetails> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.powerbidedicated.CapacityDetails::class == javaResource::class

    override fun map(javaResource: Resource): CapacityDetails = CapacityDetails(
        javaResource as
            com.pulumi.azurenative.powerbidedicated.CapacityDetails,
    )
}

/**
 * @see [CapacityDetails].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CapacityDetails].
 */
public suspend fun capacityDetails(
    name: String,
    block: suspend CapacityDetailsResourceBuilder.() -> Unit,
): CapacityDetails {
    val builder = CapacityDetailsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CapacityDetails].
 * @param name The _unique_ name of the resulting resource.
 */
public fun capacityDetails(name: String): CapacityDetails {
    val builder = CapacityDetailsResourceBuilder()
    builder.name(name)
    return builder.build()
}
